/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.spotify.helios.common.descriptors.ThrottleState;

public class RestartPolicy {
    private static final long DEFAULT_IMAGE_MISSING_THROTTLE_MILLIS = 120000L;
    private static final long DEFAULT_FLAPPING_RESTART_THROTTLE_MILLIS = 30000L;
    private static final long DEFAULT_RESTART_INTERVAL_MILLIS = 100L;
    private static final long DEFAULT_RETRY_INTERVAL_MILLIS = 1000L;
    private static final long IMAGE_PULL_FAILED_THROTTLE_MILLIS = 30000L;
    private final long restartIntervalMillis;
    private final long flappingThrottleMillis;
    private final long retryIntervalMillis;
    private final long imageMissingThrottleMillis;

    public RestartPolicy(long restartIntervalMillis, long flappingThrottleMillis, long retryIntervalMillis, long imageMissingThrottleMillis) {
        this.restartIntervalMillis = restartIntervalMillis;
        this.flappingThrottleMillis = flappingThrottleMillis;
        this.retryIntervalMillis = retryIntervalMillis;
        this.imageMissingThrottleMillis = imageMissingThrottleMillis;
    }

    public long delay(ThrottleState throttle) {
        return Math.max(this.retryIntervalMillis, this.delay0(throttle));
    }

    private long delay0(ThrottleState throttle) {
        switch (throttle) {
            case NO: {
                return this.restartIntervalMillis;
            }
            case IMAGE_MISSING: {
                return this.imageMissingThrottleMillis;
            }
            case FLAPPING: {
                return this.flappingThrottleMillis;
            }
            case IMAGE_PULL_FAILED: {
                return 30000L;
            }
        }
        throw new IllegalStateException("Should never get here, covered both cases");
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private long restartIntervalMillis = 100L;
        private long flappingThrottleMillis = 30000L;
        private long retryIntervalMillis = 1000L;
        private long imageMissingThrottleMillis = 120000L;

        private Builder() {
        }

        public Builder setNormalRestartIntervalMillis(long interval) {
            this.restartIntervalMillis = interval;
            return this;
        }

        public Builder setFlappingThrottleMills(long interval) {
            this.flappingThrottleMillis = interval;
            return this;
        }

        public Builder setRetryIntervalMillis(long retryIntervalMillis) {
            this.retryIntervalMillis = retryIntervalMillis;
            return this;
        }

        public Builder setImageMissingThrottleMillis(long imageMissingThrottleMillis) {
            this.imageMissingThrottleMillis = imageMissingThrottleMillis;
            return this;
        }

        public RestartPolicy build() {
            return new RestartPolicy(this.restartIntervalMillis, this.flappingThrottleMillis, this.retryIntervalMillis, this.imageMissingThrottleMillis);
        }
    }
}

