/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.ImageInfo;
import com.spotify.docker.client.messages.LogConfig;
import com.spotify.helios.agent.ContainerDecorator;
import com.spotify.helios.common.descriptors.Job;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SyslogRedirectingContainerDecorator
implements ContainerDecorator {
    private final String syslogHostPort;

    public SyslogRedirectingContainerDecorator(String syslogHostPort) {
        this.syslogHostPort = syslogHostPort;
    }

    @Override
    public void decorateHostConfig(Job job, Optional<String> dockerVersion, HostConfig.Builder hostConfig) {
        if (this.useSyslogRedirector(dockerVersion)) {
            ArrayList binds = Lists.newArrayList();
            if (hostConfig.binds() != null) {
                binds.addAll(hostConfig.binds());
            }
            binds.add("/usr/lib/helios:/helios:ro");
            hostConfig.binds((List)binds);
        } else {
            ImmutableMap.Builder logOpts = ImmutableMap.builder();
            logOpts.put((Object)"syslog-address", (Object)("udp://" + this.syslogHostPort));
            logOpts.put((Object)"syslog-facility", (Object)"local0");
            logOpts.put((Object)"tag", (Object)job.getId().toString());
            hostConfig.logConfig(LogConfig.create((String)"syslog", (Map)logOpts.build()));
        }
    }

    @Override
    public void decorateContainerConfig(Job job, ImageInfo imageInfo, Optional<String> dockerVersion, ContainerConfig.Builder containerConfig) {
        if (!this.useSyslogRedirector(dockerVersion)) {
            return;
        }
        ContainerConfig imageConfig = imageInfo.config();
        String syslogRedirectorPath = (String)Optional.fromNullable(job.getEnv().get("SYSLOG_REDIRECTOR")).or((Object)"/helios/syslog-redirector");
        ArrayList entrypoint = Lists.newArrayList((Object[])new String[]{syslogRedirectorPath, "-h", this.syslogHostPort, "-n", job.getId().toString(), "--"});
        if (imageConfig.entrypoint() != null) {
            entrypoint.addAll(imageConfig.entrypoint());
        }
        containerConfig.entrypoint((List)entrypoint);
        if ((containerConfig.cmd() == null || containerConfig.cmd().isEmpty()) && imageConfig.cmd() != null) {
            containerConfig.cmd(imageConfig.cmd());
        }
        HashSet volumes = Sets.newHashSet();
        if (containerConfig.volumes() != null) {
            volumes.addAll(containerConfig.volumes());
        }
        volumes.add("/helios");
        containerConfig.volumes((Set)volumes);
    }

    private boolean useSyslogRedirector(Optional<String> dockerVersion) {
        if (!dockerVersion.isPresent()) {
            return true;
        }
        String version = (String)dockerVersion.get();
        return version.startsWith("1.6.") || version.startsWith("1.7.") || version.startsWith("1.8.");
    }
}

