/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.ImageInfo;
import com.spotify.docker.client.messages.PortBinding;
import com.spotify.helios.agent.ContainerDecorator;
import com.spotify.helios.common.descriptors.HealthCheck;
import com.spotify.helios.common.descriptors.HttpHealthCheck;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.Resources;
import com.spotify.helios.common.descriptors.ServiceEndpoint;
import com.spotify.helios.common.descriptors.ServicePortParameters;
import com.spotify.helios.common.descriptors.ServicePorts;
import com.spotify.helios.common.descriptors.TcpHealthCheck;
import com.spotify.helios.serviceregistration.ServiceRegistration;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskConfig {
    private static final Logger log = LoggerFactory.getLogger(TaskConfig.class);
    private static final Pattern CONTAINER_NAME_FORBIDDEN = Pattern.compile("[^a-zA-Z0-9_-]");
    private final String host;
    private final Map<String, Integer> ports;
    private final Job job;
    private final Map<String, String> envVars;
    private final List<ContainerDecorator> containerDecorators;
    private final String namespace;
    private final String defaultRegistrationDomain;
    private final List<String> dns;

    private TaskConfig(Builder builder) {
        this.host = (String)Preconditions.checkNotNull((Object)builder.host, (Object)"host");
        this.ports = (Map)Preconditions.checkNotNull((Object)builder.ports, (Object)"ports");
        this.job = (Job)Preconditions.checkNotNull((Object)builder.job, (Object)"job");
        this.envVars = (Map)Preconditions.checkNotNull((Object)builder.envVars, (Object)"envVars");
        this.containerDecorators = (List)Preconditions.checkNotNull((Object)builder.containerDecorators, (Object)"containerDecorators");
        this.namespace = (String)Preconditions.checkNotNull((Object)builder.namespace, (Object)"namespace");
        this.defaultRegistrationDomain = (String)Preconditions.checkNotNull((Object)builder.defaultRegistrationDomain, (Object)"defaultRegistrationDomain");
        this.dns = (List)Preconditions.checkNotNull((Object)builder.dns, (Object)"dns");
    }

    public String containerName() {
        String shortId = this.job.getId().toShortString();
        String escaped = CONTAINER_NAME_FORBIDDEN.matcher(shortId).replaceAll("_");
        String random = Integer.toHexString(new SecureRandom().nextInt());
        return this.namespace + "-" + escaped + "_" + random;
    }

    public ContainerConfig containerConfig(ImageInfo imageInfo, Optional<String> dockerVersion) {
        ContainerConfig.Builder builder = ContainerConfig.builder();
        builder.image(this.job.getImage());
        builder.cmd(this.job.getCommand());
        builder.hostname(this.job.getHostname());
        builder.env(this.containerEnvStrings());
        builder.exposedPorts(this.containerExposedPorts());
        builder.volumes(this.volumes());
        for (ContainerDecorator decorator : this.containerDecorators) {
            decorator.decorateContainerConfig(this.job, imageInfo, dockerVersion, builder);
        }
        return builder.build();
    }

    public Map<String, PortMapping> ports() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry e : this.job.getPorts().entrySet()) {
            PortMapping mapping = (PortMapping)e.getValue();
            builder.put(e.getKey(), (Object)(mapping.hasExternalPort() ? mapping : mapping.withExternalPort((Integer)Preconditions.checkNotNull((Object)this.ports.get(e.getKey())))));
        }
        return builder.build();
    }

    public Map<String, String> containerEnv() {
        HashMap env = Maps.newHashMap(this.envVars);
        for (Map.Entry<String, Integer> entry : this.ports.entrySet()) {
            env.put("HELIOS_PORT_" + entry.getKey(), this.host + ":" + entry.getValue());
        }
        env.putAll(this.job.getEnv());
        return env;
    }

    public ServiceRegistration registration() throws InterruptedException {
        ServiceRegistration.Builder builder = ServiceRegistration.newBuilder();
        for (Map.Entry entry : this.job.getRegistration().entrySet()) {
            ServiceEndpoint registration = (ServiceEndpoint)entry.getKey();
            ServicePorts servicePorts = (ServicePorts)entry.getValue();
            for (Map.Entry portEntry : servicePorts.getPorts().entrySet()) {
                String portName = (String)portEntry.getKey();
                ServicePortParameters portParameters = (ServicePortParameters)portEntry.getValue();
                PortMapping mapping = (PortMapping)this.job.getPorts().get(portName);
                if (mapping == null) {
                    log.error("no '{}' port mapped for registration: '{}'", (Object)portName, (Object)registration);
                    continue;
                }
                Integer externalPort = mapping.getExternalPort() != null ? mapping.getExternalPort() : this.ports.get(portName);
                if (externalPort == null) {
                    log.error("no external '{}' port for registration: '{}'", (Object)portName, (Object)registration);
                    continue;
                }
                builder.endpoint(registration.getName(), registration.getProtocol(), externalPort.intValue(), this.fullyQualifiedRegistrationDomain(), this.host, portParameters.getTags(), this.endpointHealthCheck(portName));
            }
        }
        return builder.build();
    }

    private ServiceRegistration.EndpointHealthCheck endpointHealthCheck(String portName) {
        if (this.healthCheck() instanceof HttpHealthCheck) {
            HttpHealthCheck httpHealthCheck = (HttpHealthCheck)this.healthCheck();
            if (portName.equals(httpHealthCheck.getPort())) {
                return ServiceRegistration.EndpointHealthCheck.newHttpCheck((String)httpHealthCheck.getPath());
            }
        } else if (this.healthCheck() instanceof TcpHealthCheck && portName.equals(((TcpHealthCheck)this.healthCheck()).getPort())) {
            return ServiceRegistration.EndpointHealthCheck.newTcpCheck();
        }
        return null;
    }

    public HealthCheck healthCheck() {
        return this.job.getHealthCheck();
    }

    private String fullyQualifiedRegistrationDomain() {
        if (this.job.getRegistrationDomain().endsWith(".")) {
            return this.job.getRegistrationDomain();
        }
        if ("".equals(this.job.getRegistrationDomain())) {
            return this.defaultRegistrationDomain;
        }
        return this.job.getRegistrationDomain() + "." + this.defaultRegistrationDomain;
    }

    private Set<String> containerExposedPorts() {
        HashSet ports = Sets.newHashSet();
        for (Map.Entry entry : this.job.getPorts().entrySet()) {
            PortMapping mapping = (PortMapping)entry.getValue();
            ports.add(this.containerPort(mapping.getInternalPort(), mapping.getProtocol()));
        }
        return ports;
    }

    private List<String> containerEnvStrings() {
        Map<String, String> env = this.containerEnv();
        ArrayList envList = Lists.newArrayList();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            envList.add(entry.getKey() + '=' + entry.getValue());
        }
        return envList;
    }

    private Map<String, List<PortBinding>> portBindings() {
        HashMap bindings = Maps.newHashMap();
        for (Map.Entry e : this.job.getPorts().entrySet()) {
            PortMapping mapping = (PortMapping)e.getValue();
            PortBinding binding = new PortBinding();
            Integer externalPort = mapping.getExternalPort();
            if (externalPort == null) {
                binding.hostPort(this.ports.get(e.getKey()).toString());
            } else {
                binding.hostPort(externalPort.toString());
            }
            String entry = this.containerPort(mapping.getInternalPort(), mapping.getProtocol());
            bindings.put(entry, Collections.singletonList(binding));
        }
        return bindings;
    }

    public HostConfig hostConfig(Optional<String> dockerVersion) {
        List securityOpt = this.job.getSecurityOpt();
        HostConfig.Builder builder = HostConfig.builder().binds(this.binds()).portBindings(this.portBindings()).dns(this.dns).securityOpt(securityOpt.toArray(new String[securityOpt.size()])).networkMode(this.job.getNetworkMode());
        Resources resources = this.job.getResources();
        if (resources != null) {
            builder.memory(resources.getMemory());
            builder.memorySwap(resources.getMemorySwap());
            builder.cpusetCpus(resources.getCpuset());
            builder.cpuShares(resources.getCpuShares());
        }
        builder.capAdd((List)ImmutableList.copyOf((Collection)this.job.getAddCapabilities()));
        builder.capDrop((List)ImmutableList.copyOf((Collection)this.job.getDropCapabilities()));
        for (ContainerDecorator decorator : this.containerDecorators) {
            decorator.decorateHostConfig(this.job, dockerVersion, builder);
        }
        return builder.build();
    }

    private Set<String> volumes() {
        ImmutableSet.Builder volumes = ImmutableSet.builder();
        for (Map.Entry entry : this.job.getVolumes().entrySet()) {
            String path = (String)entry.getKey();
            String source = (String)entry.getValue();
            if (!Strings.isNullOrEmpty((String)source)) continue;
            volumes.add((Object)path);
        }
        return volumes.build();
    }

    private List<String> binds() {
        ImmutableList.Builder binds = ImmutableList.builder();
        for (Map.Entry entry : this.job.getVolumes().entrySet()) {
            String path = (String)entry.getKey();
            String source = (String)entry.getValue();
            if (Strings.isNullOrEmpty((String)source)) continue;
            binds.add((Object)(source + ":" + path));
        }
        return binds.build();
    }

    private String containerPort(int port, String protocol) {
        return port + "/" + protocol;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String containerImage() {
        return this.job.getImage();
    }

    public String name() {
        return this.job.getId().toShortString();
    }

    public String toString() {
        return "TaskConfig{host='" + this.host + '\'' + ", ports=" + this.ports + ", job=" + this.job + ", envVars=" + this.envVars + ", containerDecorators=" + this.containerDecorators + ", namespace='" + this.namespace + '\'' + ", defaultRegistrationDomain='" + this.defaultRegistrationDomain + '\'' + ", dns=" + this.dns + '}';
    }

    public static class Builder {
        private String host;
        private Job job;
        private Map<String, Integer> ports = Collections.emptyMap();
        private Map<String, String> envVars = Collections.emptyMap();
        private List<ContainerDecorator> containerDecorators = Lists.newArrayList();
        private String namespace;
        private String defaultRegistrationDomain = "";
        private List<String> dns = Collections.emptyList();

        private Builder() {
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder job(Job job) {
            this.job = job;
            return this;
        }

        public Builder defaultRegistrationDomain(String domain) {
            this.defaultRegistrationDomain = (String)Preconditions.checkNotNull((Object)domain, (Object)"domain");
            return this;
        }

        public Builder ports(Map<String, Integer> ports) {
            this.ports = ports;
            return this;
        }

        public Builder envVars(Map<String, String> envVars) {
            this.envVars = envVars;
            return this;
        }

        public Builder containerDecorators(List<ContainerDecorator> containerDecorators) {
            this.containerDecorators = containerDecorators;
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder dns(List<String> dns) {
            this.dns = dns;
            return this;
        }

        public TaskConfig build() {
            return new TaskConfig(this);
        }
    }
}

