/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.ContainerNotFoundException;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.exceptions.DockerTimeoutException;
import com.spotify.docker.client.exceptions.ImageNotFoundException;
import com.spotify.docker.client.exceptions.ImagePullFailedException;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerExit;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.ContainerState;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.ImageInfo;
import com.spotify.helios.agent.BoundedRandomExponentialBackoff;
import com.spotify.helios.agent.HealthChecker;
import com.spotify.helios.agent.Result;
import com.spotify.helios.agent.RetryScheduler;
import com.spotify.helios.agent.TaskConfig;
import com.spotify.helios.common.HeliosRuntimeException;
import com.spotify.helios.serviceregistration.NopServiceRegistrar;
import com.spotify.helios.serviceregistration.ServiceRegistrar;
import com.spotify.helios.serviceregistration.ServiceRegistrationHandle;
import com.spotify.helios.servicescommon.InterruptingExecutionThreadService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TaskRunner
extends InterruptingExecutionThreadService {
    private static final Logger log = LoggerFactory.getLogger(TaskRunner.class);
    private final long delayMillis;
    private final SettableFuture<Integer> result = SettableFuture.create();
    private final TaskConfig config;
    private final DockerClient docker;
    private final String existingContainerId;
    private final Listener listener;
    private final ServiceRegistrar registrar;
    private final Optional<HealthChecker> healthChecker;
    private Optional<ServiceRegistrationHandle> serviceRegistrationHandle;
    private Optional<String> containerId;
    private final String containerName;
    private int secondsToWaitBeforeKill;

    private TaskRunner(Builder builder) {
        super("TaskRunner(" + builder.taskConfig.name() + ")");
        this.delayMillis = builder.delayMillis;
        this.config = (TaskConfig)Preconditions.checkNotNull((Object)builder.taskConfig, (Object)"config");
        this.containerName = this.config.containerName();
        this.docker = (DockerClient)Preconditions.checkNotNull((Object)builder.docker, (Object)"docker");
        this.listener = (Listener)Preconditions.checkNotNull((Object)builder.listener, (Object)"listener");
        this.existingContainerId = builder.existingContainerId;
        this.registrar = (ServiceRegistrar)Preconditions.checkNotNull((Object)builder.registrar, (Object)"registrar");
        this.secondsToWaitBeforeKill = (Integer)Preconditions.checkNotNull((Object)builder.secondsToWaitBeforeKill, (Object)"waitBeforeKill");
        this.healthChecker = Optional.fromNullable((Object)builder.healthChecker);
        this.serviceRegistrationHandle = Optional.absent();
        this.containerId = Optional.absent();
    }

    public Result<Integer> result() {
        return Result.of(this.result);
    }

    public ListenableFuture<Integer> resultFuture() {
        return this.result;
    }

    public boolean unregister() {
        if (this.serviceRegistrationHandle.isPresent()) {
            this.registrar.unregister((ServiceRegistrationHandle)this.serviceRegistrationHandle.get());
            this.serviceRegistrationHandle = Optional.absent();
            return true;
        }
        return false;
    }

    public void stop() throws InterruptedException {
        block2: {
            String container = (String)this.containerId.or((Object)this.containerName);
            this.stopAsync().awaitTerminated();
            try {
                this.docker.stopContainer(container, this.secondsToWaitBeforeKill);
            }
            catch (DockerException e) {
                if (e instanceof ContainerNotFoundException && !this.containerId.isPresent()) break block2;
                log.warn("Stopping container {} failed", (Object)container, (Object)e);
            }
        }
    }

    protected String getContainerError() {
        ContainerInfo info;
        try {
            info = this.getContainerInfo((String)this.containerId.orNull());
        }
        catch (DockerException | InterruptedException e) {
            log.warn("failed to propagate container error: {}", e);
            return "";
        }
        if (info == null) {
            return "";
        }
        return info.state().error();
    }

    protected void run() {
        try {
            int exitCode = this.run0();
            this.result.set((Object)exitCode);
        }
        catch (Exception e) {
            this.listener.failed(e, this.getContainerError());
            this.result.setException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run0() throws InterruptedException, DockerException {
        ContainerExit exit;
        String containerId;
        Thread.sleep(this.delayMillis);
        ContainerInfo info = this.getContainerInfo(this.existingContainerId);
        if (info != null && info.state().running().booleanValue()) {
            containerId = this.existingContainerId;
            this.containerId = Optional.of((Object)this.existingContainerId);
        } else {
            containerId = this.createAndStartContainer();
            this.containerId = Optional.of((Object)containerId);
            if (this.healthChecker.isPresent()) {
                this.listener.healthChecking();
                RetryScheduler retryScheduler = BoundedRandomExponentialBackoff.newBuilder().setMinIntervalMillis(TimeUnit.SECONDS.toMillis(1L)).setMaxIntervalMillis(TimeUnit.SECONDS.toMillis(30L)).build().newScheduler();
                while (!((HealthChecker)this.healthChecker.get()).check(containerId)) {
                    ContainerState state = this.getContainerState(containerId);
                    if (state == null) {
                        String err = "container " + containerId + " was not found during health checking, or has no State object";
                        log.warn(err);
                        throw new RuntimeException(err);
                    }
                    if (!state.running().booleanValue()) {
                        String err = "container " + containerId + " exited during health checking. Exit code: " + state.exitCode() + ", Config: " + this.config;
                        log.warn(err);
                        throw new RuntimeException(err);
                    }
                    long retryMillis = retryScheduler.nextMillis();
                    log.warn("container failed healthcheck, will retry in {}ms: {}: {}", new Object[]{retryMillis, this.config, containerId});
                    Thread.sleep(retryMillis);
                }
                log.info("healthchecking complete of containerId={} taskConfig={}", (Object)containerId, (Object)this.config);
            } else {
                log.info("no healthchecks configured for containerId={} taskConfig={}", (Object)containerId, (Object)this.config);
            }
        }
        this.listener.running();
        this.serviceRegistrationHandle = Optional.fromNullable((Object)this.registrar.register(this.config.registration()));
        try {
            exit = this.docker.waitContainer(containerId);
        }
        finally {
            this.unregister();
            this.containerId = Optional.absent();
        }
        log.info("container exited: {}: {}: {}", new Object[]{this.config, containerId, exit.statusCode()});
        this.listener.exited(exit.statusCode());
        return exit.statusCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createAndStartContainer() throws DockerException, InterruptedException {
        String version;
        boolean serializePulls = false;
        Optional<String> dockerVersion = this.tryGetDockerVersion();
        if (dockerVersion.isPresent() && ((version = (String)dockerVersion.get()).startsWith("1.6.") || version.startsWith("1.7.") || version.startsWith("1.8."))) {
            serializePulls = true;
        }
        String image = this.config.containerImage();
        if (serializePulls) {
            DockerClient dockerClient = this.docker;
            synchronized (dockerClient) {
                this.pullImage(image);
            }
        } else {
            this.pullImage(image);
        }
        return this.startContainer(image, dockerVersion);
    }

    private String startContainer(String image, Optional<String> dockerVersion) throws InterruptedException, DockerException {
        ImageInfo imageInfo = this.docker.inspectImage(image);
        if (imageInfo == null) {
            throw new HeliosRuntimeException("docker inspect image returned null on image " + image);
        }
        HostConfig hostConfig = this.config.hostConfig(dockerVersion);
        ContainerConfig containerConfig = this.config.containerConfig(imageInfo, dockerVersion).toBuilder().hostConfig(hostConfig).build();
        this.listener.creating();
        ContainerCreation container = this.docker.createContainer(containerConfig, this.containerName);
        log.info("created container: {}: {}, {}", new Object[]{this.config, container, containerConfig});
        this.listener.created(container.id());
        log.info("starting container: {}: {} {}", new Object[]{this.config, container.id(), hostConfig});
        this.listener.starting();
        this.docker.startContainer(container.id());
        log.info("started container: {}: {}", (Object)this.config, (Object)container.id());
        this.listener.started();
        return container.id();
    }

    private ContainerInfo getContainerInfo(String existingContainerId) throws DockerException, InterruptedException {
        if (existingContainerId == null) {
            return null;
        }
        log.info("inspecting container: {}: {}", (Object)this.config, (Object)existingContainerId);
        try {
            return this.docker.inspectContainer(existingContainerId);
        }
        catch (ContainerNotFoundException e) {
            return null;
        }
    }

    private ContainerState getContainerState(String existingContainerId) throws DockerException, InterruptedException {
        ContainerInfo info = this.getContainerInfo(existingContainerId);
        if (info == null) {
            return null;
        }
        return info.state();
    }

    private Optional<String> tryGetDockerVersion() {
        try {
            return Optional.fromNullable((Object)this.docker.version().version());
        }
        catch (Exception e) {
            log.error("couldn't fetch Docker version: {}", (Throwable)e);
            return Optional.absent();
        }
    }

    private void pullImage(String image) throws DockerException, InterruptedException {
        this.listener.pulling();
        DockerTimeoutException wasTimeout = null;
        Stopwatch pullTime = Stopwatch.createStarted();
        try {
            this.docker.pull(image);
            this.listener.pulled();
            log.info("Pulled image {} in {}s", (Object)image, (Object)pullTime.elapsed(TimeUnit.SECONDS));
        }
        catch (DockerTimeoutException e) {
            log.warn("Pulling image {} failed with timeout after {}s", new Object[]{image, pullTime.elapsed(TimeUnit.SECONDS), e});
            this.listener.pullFailed();
            wasTimeout = e;
        }
        catch (DockerException e) {
            log.warn("Pulling image {} failed after {}s", new Object[]{image, pullTime.elapsed(TimeUnit.SECONDS), e});
            this.listener.pullFailed();
        }
        try {
            this.docker.inspectImage(image);
        }
        catch (ImageNotFoundException e) {
            if (wasTimeout != null) {
                throw new ImagePullFailedException("Failed pulling image " + image + " because of timeout", (Throwable)wasTimeout);
            }
            throw e;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class NopListener
    implements Listener {
        @Override
        public void failed(Throwable t, String containerError) {
        }

        @Override
        public void pulling() {
        }

        @Override
        public void pulled() {
        }

        @Override
        public void pullFailed() {
        }

        @Override
        public void creating() {
        }

        @Override
        public void created(String containerId) {
        }

        @Override
        public void starting() {
        }

        @Override
        public void started() {
        }

        @Override
        public void healthChecking() {
        }

        @Override
        public void running() {
        }

        @Override
        public void exited(int code) {
        }
    }

    public static class Builder {
        private long delayMillis;
        private TaskConfig taskConfig;
        private DockerClient docker;
        private String existingContainerId;
        private Listener listener;
        private HealthChecker healthChecker;
        private int secondsToWaitBeforeKill;
        public ServiceRegistrar registrar = new NopServiceRegistrar();

        private Builder() {
        }

        public Builder delayMillis(long delayMillis) {
            this.delayMillis = delayMillis;
            return this;
        }

        public Builder config(TaskConfig config) {
            this.taskConfig = config;
            return this;
        }

        public Builder docker(DockerClient docker) {
            this.docker = docker;
            return this;
        }

        public Builder existingContainerId(String existingContainerId) {
            this.existingContainerId = existingContainerId;
            return this;
        }

        public Builder listener(Listener listener) {
            this.listener = listener;
            return this;
        }

        public Builder healthChecker(HealthChecker healthChecker) {
            this.healthChecker = healthChecker;
            return this;
        }

        public Builder registrar(ServiceRegistrar registrar) {
            this.registrar = registrar;
            return this;
        }

        public Builder secondsToWaitBeforeKill(int seconds) {
            this.secondsToWaitBeforeKill = seconds;
            return this;
        }

        public TaskRunner build() {
            return new TaskRunner(this);
        }
    }

    public static interface Listener {
        public void failed(Throwable var1, String var2);

        public void pulling();

        public void pulled();

        public void pullFailed();

        public void creating();

        public void created(String var1);

        public void starting();

        public void started();

        public void healthChecking();

        public void running();

        public void exited(int var1);
    }
}

