/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.spotify.docker.client.DockerClient;
import com.spotify.helios.agent.HealthChecker;
import com.spotify.helios.agent.TaskConfig;
import com.spotify.helios.agent.TaskRunner;
import com.spotify.helios.serviceregistration.ServiceRegistrar;
import java.util.Collections;
import java.util.List;

public class TaskRunnerFactory {
    private final TaskConfig taskConfig;
    private final DockerClient docker;
    private final Optional<HealthChecker> healthChecker;
    private final ServiceRegistrar registrar;
    private final List<TaskRunner.Listener> listeners;

    public TaskRunnerFactory(Builder builder) {
        this.taskConfig = (TaskConfig)Preconditions.checkNotNull((Object)builder.config, (Object)"config");
        this.registrar = (ServiceRegistrar)Preconditions.checkNotNull((Object)builder.registrar, (Object)"registrar");
        this.docker = (DockerClient)Preconditions.checkNotNull((Object)builder.docker, (Object)"docker");
        this.listeners = (List)Preconditions.checkNotNull((Object)builder.listeners, (Object)"listeners");
        this.healthChecker = Optional.fromNullable((Object)builder.healthChecker);
    }

    public TaskRunner create(long delay, String containerId, TaskRunner.Listener listener, int secondsToWaitBeforeKill) {
        return TaskRunner.builder().delayMillis(delay).config(this.taskConfig).docker(this.docker).healthChecker((HealthChecker)this.healthChecker.orNull()).existingContainerId(containerId).listener(new BroadcastingListener(Iterables.concat(this.listeners, Collections.singletonList(listener)))).registrar(this.registrar).secondsToWaitBeforeKill(secondsToWaitBeforeKill).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private class BroadcastingListener
    implements TaskRunner.Listener {
        private final Iterable<TaskRunner.Listener> listeners;

        private BroadcastingListener(Iterable<TaskRunner.Listener> listeners) {
            this.listeners = listeners;
        }

        @Override
        public void failed(Throwable t, String containerError) {
            for (TaskRunner.Listener l : this.listeners) {
                l.failed(t, containerError);
            }
        }

        @Override
        public void pulling() {
            for (TaskRunner.Listener l : this.listeners) {
                l.pulling();
            }
        }

        @Override
        public void pulled() {
            for (TaskRunner.Listener l : this.listeners) {
                l.pulled();
            }
        }

        @Override
        public void pullFailed() {
            for (TaskRunner.Listener l : this.listeners) {
                l.pullFailed();
            }
        }

        @Override
        public void creating() {
            for (TaskRunner.Listener l : this.listeners) {
                l.creating();
            }
        }

        @Override
        public void created(String containerId) {
            for (TaskRunner.Listener l : this.listeners) {
                l.created(containerId);
            }
        }

        @Override
        public void starting() {
            for (TaskRunner.Listener l : this.listeners) {
                l.starting();
            }
        }

        @Override
        public void started() {
            for (TaskRunner.Listener l : this.listeners) {
                l.started();
            }
        }

        @Override
        public void healthChecking() {
            for (TaskRunner.Listener l : this.listeners) {
                l.healthChecking();
            }
        }

        @Override
        public void running() {
            for (TaskRunner.Listener l : this.listeners) {
                l.running();
            }
        }

        @Override
        public void exited(int code) {
            for (TaskRunner.Listener l : this.listeners) {
                l.exited(code);
            }
        }
    }

    public static class Builder {
        private TaskConfig config;
        private DockerClient docker;
        private HealthChecker healthChecker;
        private ServiceRegistrar registrar;
        private List<TaskRunner.Listener> listeners = Lists.newArrayList();

        private Builder() {
        }

        public Builder config(TaskConfig config) {
            this.config = config;
            return this;
        }

        public Builder registrar(ServiceRegistrar registrar) {
            this.registrar = registrar;
            return this;
        }

        public Builder dockerClient(DockerClient docker) {
            this.docker = docker;
            return this;
        }

        public Builder healthChecker(HealthChecker healthChecker) {
            this.healthChecker = healthChecker;
            return this;
        }

        public Builder listener(TaskRunner.Listener listener) {
            this.listeners.add(listener);
            return this;
        }

        public TaskRunnerFactory build() {
            return new TaskRunnerFactory(this);
        }
    }
}

