/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.spotify.helios.common.descriptors.DeploymentGroup;
import com.spotify.helios.common.descriptors.HostSelector;
import com.spotify.helios.rollingupdate.AlphaNumericComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostMatcher {
    private static final Logger log = LoggerFactory.getLogger(HostMatcher.class);
    private final Map<String, Map<String, String>> hostsAndLabels;

    public HostMatcher(Map<String, Map<String, String>> hostsAndLabels) {
        this.hostsAndLabels = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(hostsAndLabels, (Object)"hostsAndLabels")));
    }

    public List<String> getMatchingHosts(DeploymentGroup deploymentGroup) {
        List selectors = deploymentGroup.getHostSelectors();
        if (selectors == null || selectors.isEmpty()) {
            log.error("skipping deployment group with no host selectors: " + deploymentGroup.getName());
            return Collections.emptyList();
        }
        return this.getMatchingHosts(selectors);
    }

    public List<String> getMatchingHosts(List<HostSelector> selectors) {
        ArrayList matchingHosts = Lists.newArrayList();
        for (Map.Entry<String, Map<String, String>> entry : this.hostsAndLabels.entrySet()) {
            String host = entry.getKey();
            Map<String, String> hostLabels = entry.getValue();
            boolean match = selectors.stream().allMatch(selector -> hostLabels.containsKey(selector.getLabel()) && selector.matches((String)hostLabels.get(selector.getLabel())));
            if (!match) continue;
            matchingHosts.add(host);
        }
        Collections.sort(matchingHosts, new AlphaNumericComparator(Locale.ENGLISH));
        return ImmutableList.copyOf((Collection)matchingHosts);
    }
}

