/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master;

import com.google.common.annotations.VisibleForTesting;
import com.spotify.helios.common.LoggingConfig;
import com.spotify.helios.master.MasterConfig;
import com.spotify.helios.master.MasterParser;
import com.spotify.helios.master.MasterService;
import com.spotify.helios.servicescommon.ServiceMain;
import com.spotify.helios.servicescommon.coordination.CuratorClientFactory;
import com.spotify.helios.servicescommon.coordination.CuratorClientFactoryImpl;
import java.util.Map;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterMain
extends ServiceMain {
    private static final Logger log = LoggerFactory.getLogger(MasterMain.class);
    private final MasterConfig masterConfig;
    private final CuratorClientFactory curatorClientFactory;
    private final Map<String, String> environmentVariables;
    private MasterService service;

    public MasterMain(String[] args) throws ArgumentParserException {
        this(new CuratorClientFactoryImpl(), new MasterParser(args), System.getenv());
    }

    @VisibleForTesting
    public MasterMain(Map<String, String> environmentVariables, String[] args) throws ArgumentParserException {
        this(new CuratorClientFactoryImpl(), new MasterParser(args), environmentVariables);
    }

    public MasterMain(CuratorClientFactory curatorClientFactory, String[] args) throws ArgumentParserException {
        this(curatorClientFactory, new MasterParser(args), System.getenv());
    }

    public MasterMain(CuratorClientFactory curatorClientFactory, MasterParser parser, Map<String, String> environmentVariables) {
        this(curatorClientFactory, parser.getMasterConfig(), parser.getLoggingConfig(), environmentVariables);
    }

    public MasterMain(CuratorClientFactory curatorClientFactory, MasterConfig masterConfig, LoggingConfig loggingConfig, Map<String, String> environmentVariables) {
        super(loggingConfig, masterConfig.getSentryDsn());
        this.masterConfig = masterConfig;
        this.curatorClientFactory = curatorClientFactory;
        this.environmentVariables = environmentVariables;
    }

    protected void startUp() throws Exception {
        this.service = new MasterService(this.masterConfig, MasterMain.createEnvironment("helios-master"), this.curatorClientFactory, this.environmentVariables);
        this.service.startAsync().awaitRunning();
    }

    protected void shutDown() throws Exception {
        this.service.stopAsync().awaitTerminated();
    }

    public static void main(String ... args) {
        try {
            MasterMain main = new MasterMain(args);
            main.startAsync().awaitRunning();
            main.awaitTerminated();
        }
        catch (Throwable e) {
            log.error("Uncaught exception", e);
            System.exit(1);
        }
        System.exit(0);
    }
}

