/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master;

import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.DeploymentGroup;
import com.spotify.helios.common.descriptors.DeploymentGroupStatus;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.common.descriptors.RolloutOptions;
import com.spotify.helios.common.descriptors.TaskStatusEvent;
import com.spotify.helios.master.DeploymentGroupDoesNotExistException;
import com.spotify.helios.master.DeploymentGroupExistsException;
import com.spotify.helios.master.HostNotFoundException;
import com.spotify.helios.master.HostStillInUseException;
import com.spotify.helios.master.JobAlreadyDeployedException;
import com.spotify.helios.master.JobDoesNotExistException;
import com.spotify.helios.master.JobExistsException;
import com.spotify.helios.master.JobNotDeployedException;
import com.spotify.helios.master.JobPortAllocationConflictException;
import com.spotify.helios.master.JobStillDeployedException;
import com.spotify.helios.master.TokenVerificationException;
import java.util.List;
import java.util.Map;

public interface MasterModel {
    public void registerHost(String var1, String var2);

    public void deregisterHost(String var1) throws HostNotFoundException, HostStillInUseException;

    public List<String> listHosts();

    public HostStatus getHostStatus(String var1);

    public void addJob(Job var1) throws JobExistsException;

    public Job getJob(JobId var1);

    public Map<JobId, Job> getJobs();

    public JobStatus getJobStatus(JobId var1);

    public Job removeJob(JobId var1) throws JobDoesNotExistException, JobStillDeployedException;

    public Job removeJob(JobId var1, String var2) throws JobDoesNotExistException, JobStillDeployedException, TokenVerificationException;

    public void deployJob(String var1, Deployment var2) throws HostNotFoundException, JobAlreadyDeployedException, JobDoesNotExistException, JobPortAllocationConflictException;

    public void deployJob(String var1, Deployment var2, String var3) throws HostNotFoundException, JobAlreadyDeployedException, JobDoesNotExistException, JobPortAllocationConflictException, TokenVerificationException;

    public Deployment getDeployment(String var1, JobId var2);

    public Deployment undeployJob(String var1, JobId var2) throws HostNotFoundException, JobNotDeployedException;

    public Deployment undeployJob(String var1, JobId var2, String var3) throws HostNotFoundException, JobNotDeployedException, TokenVerificationException;

    public void updateDeployment(String var1, Deployment var2) throws HostNotFoundException, JobNotDeployedException;

    public void updateDeployment(String var1, Deployment var2, String var3) throws HostNotFoundException, JobNotDeployedException, TokenVerificationException;

    public List<String> getRunningMasters();

    public List<TaskStatusEvent> getJobHistory(JobId var1) throws JobDoesNotExistException;

    public List<TaskStatusEvent> getJobHistory(JobId var1, String var2) throws JobDoesNotExistException;

    public void addDeploymentGroup(DeploymentGroup var1) throws DeploymentGroupExistsException;

    public DeploymentGroup getDeploymentGroup(String var1) throws DeploymentGroupDoesNotExistException;

    public Map<String, DeploymentGroup> getDeploymentGroups();

    public List<String> getDeploymentGroupHosts(String var1) throws DeploymentGroupDoesNotExistException;

    public void updateDeploymentGroupHosts(String var1, List<String> var2) throws DeploymentGroupDoesNotExistException;

    public DeploymentGroupStatus getDeploymentGroupStatus(String var1) throws DeploymentGroupDoesNotExistException;

    public void removeDeploymentGroup(String var1) throws DeploymentGroupDoesNotExistException;

    public void rollingUpdate(DeploymentGroup var1, JobId var2, RolloutOptions var3) throws DeploymentGroupDoesNotExistException, JobDoesNotExistException;

    public void rollingUpdateStep();

    public void stopDeploymentGroup(String var1) throws DeploymentGroupDoesNotExistException;
}

