/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master;

import com.google.common.collect.ImmutableSet;
import com.spotify.helios.master.MasterConfig;
import com.spotify.helios.servicescommon.ServiceParser;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;

public class MasterParser
extends ServiceParser {
    private static final String ZK_MASTER_PASSWORD_ENVVAR = "HELIOS_ZK_MASTER_PASSWORD";
    private final MasterConfig masterConfig;
    private Argument httpArg;
    private Argument adminArg;
    private Argument zkAclAgentDigest;
    private Argument zkAclMasterPassword;
    private Argument agentReapingTimeout;
    private Argument jobRetention;
    private Argument whitelistedCapabilities;
    private Argument jobHistoryReapingEnabled;

    public MasterParser(String ... args) throws ArgumentParserException {
        super("helios-master", "Spotify Helios Master", args);
        MasterConfig config;
        Namespace options = this.getNamespace();
        InetSocketAddress httpAddress = this.parseSocketAddress(options.getString(this.httpArg.getDest()));
        InetSocketAddress adminAddress = this.parseSocketAddress(options.getString(this.adminArg.getDest()));
        String masterPassword = System.getenv(ZK_MASTER_PASSWORD_ENVVAR);
        if (masterPassword == null) {
            masterPassword = options.getString(this.zkAclMasterPassword.getDest());
        }
        this.masterConfig = config = new MasterConfig().setZooKeeperConnectString(this.getZooKeeperConnectString()).setZooKeeperSessionTimeoutMillis(this.getZooKeeperSessionTimeoutMillis()).setZooKeeperConnectionTimeoutMillis(this.getZooKeeperConnectionTimeoutMillis()).setZooKeeperClusterId(this.getZooKeeperClusterId()).setNoZooKeeperMasterRegistration(this.getNoZooKeeperRegistration()).setZooKeeperEnableAcls(this.getZooKeeperEnableAcls()).setZookeeperAclAgentUser(this.getZooKeeperAclAgentUser()).setZooKeeperAclAgentDigest(options.getString(this.zkAclAgentDigest.getDest())).setZookeeperAclMasterUser(this.getZooKeeperAclMasterUser()).setZooKeeperAclMasterPassword(masterPassword).setDomain(this.getDomain()).setName(this.getName()).setStatsdHostPort(this.getStatsdHostPort()).setRiemannHostPort(this.getRiemannHostPort()).setInhibitMetrics(this.getInhibitMetrics()).setSentryDsn(this.getSentryDsn()).setServiceRegistryAddress(this.getServiceRegistryAddress()).setServiceRegistrarPlugin(this.getServiceRegistrarPlugin()).setAdminEndpoint(adminAddress).setHttpEndpoint(httpAddress).setKafkaBrokers(this.getKafkaBrokers()).setPubsubPrefixes(this.getPubsubPrefixes()).setStateDirectory(this.getStateDirectory()).setAgentReapingTimeout(options.getLong(this.agentReapingTimeout.getDest())).setJobRetention(options.getLong(this.jobRetention.getDest())).setFfwdConfig(this.ffwdConfig(options)).setWhitelistedCapabilities((Set<String>)ImmutableSet.copyOf((Collection)options.getList(this.whitelistedCapabilities.getDest()))).setJobHistoryReapingEnabled(options.getBoolean(this.jobHistoryReapingEnabled.getDest()));
    }

    @Override
    protected void addArgs(ArgumentParser parser) {
        this.httpArg = parser.addArgument(new String[]{"--http"}).setDefault((Object)"http://0.0.0.0:5801").help("http endpoint");
        this.adminArg = parser.addArgument(new String[]{"--admin"}).setDefault((Object)"http://0.0.0.0:5802").help("admin http port");
        this.zkAclAgentDigest = parser.addArgument(new String[]{"--zk-acl-agent-digest"}).type(String.class);
        this.zkAclMasterPassword = parser.addArgument(new String[]{"--zk-acl-master-password"}).type(String.class).help("ZooKeeper master password (for ZooKeeper ACLs). If the HELIOS_ZK_MASTER_PASSWORD environment variable is present this argument is ignored.");
        this.agentReapingTimeout = parser.addArgument(new String[]{"--agent-reaping-timeout"}).type(Long.class).setDefault((Object)TimeUnit.DAYS.toHours(14L)).help("In hours. Agents will be automatically de-registered if they are DOWN for more than the specified timeout. To disable reaping, set to 0.");
        this.jobRetention = parser.addArgument(new String[]{"--job-retention"}).type(Long.class).setDefault((Object)-1L).help("In days. Jobs not deployed anywhere and with a job history showing they were last used before the specified retention time will be removed. This is disabled by default by setting it to a sentinel value of -1.");
        this.whitelistedCapabilities = parser.addArgument(new String[]{"--whitelisted-capability"}).action((ArgumentAction)Arguments.append()).setDefault(new ArrayList()).help("The Linux capabilities Helios jobs are allowed to add to their Docker containers. Defaults to allowing nothing.");
        this.jobHistoryReapingEnabled = parser.addArgument(new String[]{"--reap-history"}).action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false).help("Enable periodic reaping of orphaned job histories.");
    }

    public MasterConfig getMasterConfig() {
        return this.masterConfig;
    }
}

