/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master;

import ch.qos.logback.access.jetty.RequestLogImpl;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import com.google.common.util.concurrent.AbstractIdleService;
import com.spotify.helios.common.HeliosRuntimeException;
import com.spotify.helios.master.MasterConfig;
import com.spotify.helios.master.MasterZooKeeperRegistrar;
import com.spotify.helios.master.UserProvider;
import com.spotify.helios.master.ZooKeeperMasterModel;
import com.spotify.helios.master.http.VersionResponseFilter;
import com.spotify.helios.master.metrics.HealthCheckGauge;
import com.spotify.helios.master.metrics.ReportingResourceMethodDispatchAdapter;
import com.spotify.helios.master.reaper.DeadAgentReaper;
import com.spotify.helios.master.reaper.ExpiredJobReaper;
import com.spotify.helios.master.reaper.JobHistoryReaper;
import com.spotify.helios.master.reaper.OldJobReaper;
import com.spotify.helios.master.resources.DeploymentGroupResource;
import com.spotify.helios.master.resources.HistoryResource;
import com.spotify.helios.master.resources.HostsResource;
import com.spotify.helios.master.resources.JobsResource;
import com.spotify.helios.master.resources.MastersResource;
import com.spotify.helios.master.resources.VersionResource;
import com.spotify.helios.rollingupdate.RollingUpdateService;
import com.spotify.helios.serviceregistration.ServiceRegistrar;
import com.spotify.helios.serviceregistration.ServiceRegistration;
import com.spotify.helios.servicescommon.EventSender;
import com.spotify.helios.servicescommon.FastForwardConfig;
import com.spotify.helios.servicescommon.GooglePubSubProvider;
import com.spotify.helios.servicescommon.KafkaClientProvider;
import com.spotify.helios.servicescommon.KafkaSender;
import com.spotify.helios.servicescommon.ManagedStatsdReporter;
import com.spotify.helios.servicescommon.ReactorFactory;
import com.spotify.helios.servicescommon.RiemannFacade;
import com.spotify.helios.servicescommon.RiemannHeartBeat;
import com.spotify.helios.servicescommon.RiemannSupport;
import com.spotify.helios.servicescommon.ServiceRegistrars;
import com.spotify.helios.servicescommon.ServiceUtil;
import com.spotify.helios.servicescommon.ZooKeeperAclProviders;
import com.spotify.helios.servicescommon.ZooKeeperRegistrarService;
import com.spotify.helios.servicescommon.coordination.CuratorClientFactory;
import com.spotify.helios.servicescommon.coordination.DefaultZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClientProvider;
import com.spotify.helios.servicescommon.coordination.ZooKeeperHealthChecker;
import com.spotify.helios.servicescommon.coordination.ZooKeeperModelReporter;
import com.spotify.helios.servicescommon.statistics.FastForwardReporter;
import com.spotify.helios.servicescommon.statistics.Metrics;
import com.spotify.helios.servicescommon.statistics.MetricsImpl;
import com.spotify.helios.servicescommon.statistics.NoopMetrics;
import io.dropwizard.configuration.ConfigurationException;
import io.dropwizard.jetty.GzipFilterFactory;
import io.dropwizard.jetty.RequestLogFactory;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.server.DefaultServerFactory;
import io.dropwizard.setup.Environment;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.AuthInfo;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.zookeeper.data.ACL;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterService
extends AbstractIdleService {
    private static final Logger log = LoggerFactory.getLogger(MasterService.class);
    private static final String LOGBACK_ACCESS_CONFIG = "logback-access.xml";
    private static final String LOGBACK_ACCESS_RESOURCE = "/logback-access.xml";
    private final Server server;
    private final MasterConfig config;
    private final ServiceRegistrar registrar;
    private final ZooKeeperClient zooKeeperClient;
    private final ExpiredJobReaper expiredJobReaper;
    private final CuratorClientFactory curatorClientFactory;
    private final RollingUpdateService rollingUpdateService;
    private final Map<String, String> environmentVariables;
    private final Optional<DeadAgentReaper> agentReaper;
    private final Optional<OldJobReaper> oldJobReaper;
    private final Optional<JobHistoryReaper> jobHistoryReaper;
    private ZooKeeperRegistrarService zkRegistrar;

    public MasterService(MasterConfig config, Environment environment, CuratorClientFactory curatorClientFactory, Map<String, String> environmentVariables) throws ConfigurationException, IOException, InterruptedException {
        Metrics metrics;
        this.config = config;
        this.curatorClientFactory = curatorClientFactory;
        this.environmentVariables = environmentVariables;
        MetricRegistry metricsRegistry = environment.metrics();
        metricsRegistry.registerAll((MetricSet)new GarbageCollectorMetricSet());
        metricsRegistry.registerAll((MetricSet)new MemoryUsageGaugeSet());
        RiemannSupport riemannSupport = new RiemannSupport(metricsRegistry, config.getRiemannHostPort(), config.getName(), "helios-master");
        RiemannFacade riemannFacade = riemannSupport.getFacade();
        log.info("Starting metrics");
        if (config.isInhibitMetrics()) {
            metrics = new NoopMetrics();
        } else {
            FastForwardConfig ffwdConfig;
            metrics = new MetricsImpl(metricsRegistry, MetricsImpl.Type.MASTER);
            metrics.start();
            environment.lifecycle().manage((Managed)riemannSupport);
            if (!Strings.isNullOrEmpty((String)config.getStatsdHostPort())) {
                environment.lifecycle().manage((Managed)new ManagedStatsdReporter(config.getStatsdHostPort(), metricsRegistry));
            }
            if ((ffwdConfig = config.getFfwdConfig()) != null) {
                environment.lifecycle().manage((Managed)FastForwardReporter.create(metricsRegistry, ffwdConfig.getAddress(), ffwdConfig.getMetricKey(), ffwdConfig.getReportingIntervalSeconds()));
            }
        }
        this.zooKeeperClient = this.setupZookeeperClient(config);
        ZooKeeperModelReporter modelReporter = new ZooKeeperModelReporter(riemannFacade, metrics.getZooKeeperMetrics());
        ZooKeeperClientProvider zkClientProvider = new ZooKeeperClientProvider(this.zooKeeperClient, modelReporter);
        KafkaClientProvider kafkaClientProvider = new KafkaClientProvider(config.getKafkaBrokers());
        GooglePubSubProvider googlePubSubProvider = new GooglePubSubProvider(config.getPubsubPrefixes());
        Path stateDirectory = config.getStateDirectory().toAbsolutePath().normalize();
        if (!Files.exists(stateDirectory, new LinkOption[0])) {
            try {
                Files.createDirectories(stateDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error("Failed to create state directory: {}", (Object)stateDirectory, (Object)e);
                throw Throwables.propagate((Throwable)e);
            }
        }
        ImmutableList.Builder eventSenders = ImmutableList.builder();
        Optional<KafkaProducer<String, byte[]>> kafkaProducer = kafkaClientProvider.getDefaultProducer();
        if (kafkaProducer.isPresent()) {
            eventSenders.add((Object)new KafkaSender(kafkaProducer));
        }
        eventSenders.addAll(googlePubSubProvider.senders());
        ZooKeeperMasterModel model = new ZooKeeperMasterModel(zkClientProvider, config.getName(), (List<EventSender>)eventSenders.build());
        ZooKeeperHealthChecker zooKeeperHealthChecker = new ZooKeeperHealthChecker(this.zooKeeperClient, Paths.statusMasters(), riemannFacade, TimeUnit.MINUTES, 2L);
        environment.lifecycle().manage((Managed)zooKeeperHealthChecker);
        environment.healthChecks().register("zookeeper", (HealthCheck)zooKeeperHealthChecker);
        environment.healthChecks().getNames().forEach(name -> {
            HealthCheckGauge cfr_ignored_0 = (HealthCheckGauge)environment.metrics().register("helios." + name + ".ok", (Metric)new HealthCheckGauge(environment.healthChecks(), (String)name));
        });
        environment.lifecycle().manage((Managed)new RiemannHeartBeat(TimeUnit.MINUTES, 2, riemannFacade));
        this.registrar = ServiceRegistrars.createServiceRegistrar(config.getServiceRegistrarPlugin(), config.getServiceRegistryAddress(), config.getDomain());
        this.expiredJobReaper = ExpiredJobReaper.newBuilder().setMasterModel(model).build();
        ReactorFactory reactorFactory = new ReactorFactory();
        this.rollingUpdateService = new RollingUpdateService(model, reactorFactory);
        if (config.getAgentReapingTimeout() > 0L) {
            this.agentReaper = Optional.of(new DeadAgentReaper(model, config.getAgentReapingTimeout()));
        } else {
            log.info("Reaping of dead agents disabled");
            this.agentReaper = Optional.empty();
        }
        if (config.getJobRetention() > 0L) {
            this.oldJobReaper = Optional.of(new OldJobReaper(model, config.getJobRetention()));
        } else {
            log.info("Reaping of old jobs disabled");
            this.oldJobReaper = Optional.empty();
        }
        if (config.isJobHistoryReapingEnabled()) {
            this.jobHistoryReaper = Optional.of(new JobHistoryReaper(model, zkClientProvider.get("jobHistoryReaper")));
        } else {
            log.info("Reaping of orphaned jobs disabled");
            this.jobHistoryReaper = Optional.empty();
        }
        environment.servlets().addFilter("VersionResponseFilter", (Filter)new VersionResponseFilter(metrics.getMasterMetrics())).addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/*"});
        environment.jersey().register((Object)new ReportingResourceMethodDispatchAdapter(metrics.getMasterMetrics()));
        environment.jersey().register((Object)new JobsResource(model, metrics.getMasterMetrics(), config.getWhitelistedCapabilities()));
        environment.jersey().register((Object)new HistoryResource(model, metrics.getMasterMetrics()));
        environment.jersey().register((Object)new HostsResource(model));
        environment.jersey().register((Object)new MastersResource(model));
        environment.jersey().register((Object)new VersionResource());
        environment.jersey().register((Object)new UserProvider());
        environment.jersey().register((Object)new DeploymentGroupResource(model));
        DefaultServerFactory serverFactory = ServiceUtil.createServerFactory(config.getHttpEndpoint(), config.getAdminEndpoint(), false);
        RequestLogFactory requestLog = new RequestLogFactory();
        requestLog.setAppenders(ImmutableList.of());
        serverFactory.setRequestLogFactory(requestLog);
        FilterRegistration.Dynamic cors = environment.servlets().addFilter("CORS", CrossOriginFilter.class);
        cors.setInitParameter("allowedOrigins", "*");
        cors.setInitParameter("allowedHeaders", "X-Requested-With,Content-Type,Accept,Origin");
        cors.setInitParameter("allowedMethods", "OPTIONS,GET,PUT,POST,DELETE,HEAD");
        cors.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
        GzipFilterFactory gzip = new GzipFilterFactory();
        gzip.setIncludedMethods((Set)ImmutableSet.of((Object)"GET", (Object)"POST"));
        serverFactory.setGzipFilterFactory(gzip);
        this.server = serverFactory.build(environment);
        this.setUpRequestLogging(stateDirectory);
    }

    private void setUpRequestLogging(Path stateDirectory) {
        HandlerCollection handlerCollection;
        Handler originalHandler = this.server.getHandler();
        if (originalHandler instanceof HandlerCollection) {
            handlerCollection = (HandlerCollection)originalHandler;
        } else {
            handlerCollection = new HandlerCollection();
            handlerCollection.addHandler(originalHandler);
        }
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        RequestLogImpl requestLog = new RequestLogImpl();
        requestLog.setQuiet(true);
        if (stateDirectory.resolve(LOGBACK_ACCESS_CONFIG).toFile().exists()) {
            requestLog.setFileName(stateDirectory.resolve(LOGBACK_ACCESS_CONFIG).toString());
        } else if (((Object)((Object)this)).getClass().getResource(LOGBACK_ACCESS_RESOURCE) != null) {
            requestLog.setResource(LOGBACK_ACCESS_RESOURCE);
        }
        requestLogHandler.setRequestLog((RequestLog)requestLog);
        handlerCollection.addHandler((Handler)requestLogHandler);
        this.server.setHandler((Handler)handlerCollection);
    }

    protected void startUp() throws Exception {
        this.logBanner();
        if (!this.config.getNoZooKeeperMasterRegistration()) {
            this.zkRegistrar.startAsync().awaitRunning();
        }
        this.expiredJobReaper.startAsync().awaitRunning();
        this.rollingUpdateService.startAsync().awaitRunning();
        this.agentReaper.ifPresent(reaper -> reaper.startAsync().awaitRunning());
        this.oldJobReaper.ifPresent(reaper -> reaper.startAsync().awaitRunning());
        this.jobHistoryReaper.ifPresent(reaper -> reaper.startAsync().awaitRunning());
        try {
            this.server.start();
        }
        catch (Exception e) {
            log.error("Unable to start server, shutting down", (Throwable)e);
            this.server.stop();
        }
        ServiceRegistration serviceRegistration = ServiceRegistration.newBuilder().endpoint("helios", "http", this.config.getHttpEndpoint().getPort(), this.config.getDomain(), this.config.getName()).build();
        this.registrar.register(serviceRegistration);
    }

    protected void shutDown() throws Exception {
        this.server.stop();
        this.server.join();
        this.registrar.close();
        this.agentReaper.ifPresent(reaper -> reaper.stopAsync().awaitTerminated());
        this.oldJobReaper.ifPresent(reaper -> reaper.stopAsync().awaitTerminated());
        this.jobHistoryReaper.ifPresent(reaper -> reaper.stopAsync().awaitTerminated());
        this.rollingUpdateService.stopAsync().awaitTerminated();
        this.expiredJobReaper.stopAsync().awaitTerminated();
        this.zkRegistrar.stopAsync().awaitTerminated();
        this.zooKeeperClient.close();
    }

    private void logBanner() {
        try {
            String banner = Resources.toString((URL)Resources.getResource((String)"master-banner.txt"), (Charset)Charsets.UTF_8);
            log.info("\n{}", (Object)banner);
        }
        catch (IOException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    private ZooKeeperClient setupZookeeperClient(MasterConfig config) {
        ACLProvider aclProvider = null;
        ArrayList authorization = null;
        String masterUser = config.getZookeeperAclMasterUser();
        String masterPassword = config.getZooKeeperAclMasterPassword();
        String agentUser = config.getZookeeperAclAgentUser();
        String agentDigest = config.getZooKeeperAclAgentDigest();
        if (!Strings.isNullOrEmpty((String)masterPassword)) {
            if (Strings.isNullOrEmpty((String)masterUser)) {
                throw new HeliosRuntimeException("Master username must be set if a password is set");
            }
            authorization = Lists.newArrayList((Object[])new AuthInfo[]{new AuthInfo("digest", String.format("%s:%s", masterUser, masterPassword).getBytes())});
        }
        if (config.isZooKeeperEnableAcls()) {
            if (Strings.isNullOrEmpty((String)masterUser) || Strings.isNullOrEmpty((String)masterPassword)) {
                throw new HeliosRuntimeException("ZooKeeper ACLs enabled but master username and/or password not set");
            }
            if (Strings.isNullOrEmpty((String)agentUser) || Strings.isNullOrEmpty((String)agentDigest)) {
                throw new HeliosRuntimeException("ZooKeeper ACLs enabled but agent username and/or digest not set");
            }
            aclProvider = ZooKeeperAclProviders.heliosAclProvider(masterUser, ZooKeeperAclProviders.digest(masterUser, masterPassword), agentUser, agentDigest);
        }
        ExponentialBackoffRetry zooKeeperRetryPolicy = new ExponentialBackoffRetry(1000, 3);
        CuratorFramework curator = this.curatorClientFactory.newClient(config.getZooKeeperConnectionString(), config.getZooKeeperSessionTimeoutMillis(), config.getZooKeeperConnectionTimeoutMillis(), (RetryPolicy)zooKeeperRetryPolicy, aclProvider, authorization);
        DefaultZooKeeperClient client = new DefaultZooKeeperClient(curator, config.getZooKeeperClusterId());
        client.start();
        this.zkRegistrar = ZooKeeperRegistrarService.newBuilder().setZooKeeperClient(client).setZooKeeperRegistrar(new MasterZooKeeperRegistrar(config.getName())).build();
        if (aclProvider != null) {
            try {
                List<ACL> curAcls = client.getAcl("/");
                List wantedAcls = aclProvider.getAclForPath("/");
                if (!Sets.newHashSet(curAcls).equals(Sets.newHashSet((Iterable)wantedAcls))) {
                    log.info("Current ACL's on the zookeeper root node differ from desired, updating: {} -> {}", curAcls, (Object)wantedAcls);
                    ((BackgroundPathable)client.getCuratorFramework().setACL().withACL(wantedAcls)).forPath("/");
                }
            }
            catch (Exception e) {
                log.error("Failed to get/set ACLs on the zookeeper root node", (Throwable)e);
            }
        }
        return client;
    }
}

