/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master;

import com.google.common.base.Optional;
import com.spotify.helios.servicescommon.ZooKeeperRegistrar;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import java.io.IOException;
import org.apache.curator.framework.recipes.nodes.PersistentEphemeralNode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterZooKeeperRegistrar
implements ZooKeeperRegistrar {
    private static final Logger log = LoggerFactory.getLogger(MasterZooKeeperRegistrar.class);
    private final String name;
    private PersistentEphemeralNode upNode;

    public MasterZooKeeperRegistrar(String name) {
        this.name = name;
    }

    @Override
    public void startUp() throws Exception {
    }

    @Override
    public void shutDown() throws Exception {
        if (this.upNode != null) {
            try {
                this.upNode.close();
            }
            catch (IOException e) {
                Throwable cause = (Throwable)Optional.fromNullable((Object)e.getCause()).or((Object)e);
                log.warn("Exception on closing up node: {}", cause);
            }
        }
    }

    @Override
    public boolean tryToRegister(ZooKeeperClient client) throws KeeperException {
        client.ensurePath(Paths.configHosts());
        client.ensurePath(Paths.configJobs());
        client.ensurePath(Paths.configJobRefs());
        client.ensurePath(Paths.statusHosts());
        client.ensurePath(Paths.statusMasters());
        client.ensurePath(Paths.historyJobs());
        client.ensurePath(Paths.configDeploymentGroups());
        client.ensurePath(Paths.statusDeploymentGroups());
        if (this.upNode == null) {
            String upPath = Paths.statusMasterUp(this.name);
            client.ensurePath(upPath, true);
            this.upNode = client.persistentEphemeralNode(upPath, PersistentEphemeralNode.Mode.EPHEMERAL, new byte[0]);
            this.upNode.start();
        }
        log.info("ZooKeeper registration complete");
        return true;
    }
}

