/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.spotify.helios.common.HeliosRuntimeException;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.AgentInfo;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.DeploymentGroup;
import com.spotify.helios.common.descriptors.DeploymentGroupStatus;
import com.spotify.helios.common.descriptors.DeploymentGroupTasks;
import com.spotify.helios.common.descriptors.Descriptor;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.HostInfo;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.RolloutOptions;
import com.spotify.helios.common.descriptors.RolloutTask;
import com.spotify.helios.common.descriptors.Task;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.descriptors.TaskStatusEvent;
import com.spotify.helios.common.descriptors.ThrottleState;
import com.spotify.helios.master.DeploymentGroupDoesNotExistException;
import com.spotify.helios.master.DeploymentGroupExistsException;
import com.spotify.helios.master.HostNotFoundException;
import com.spotify.helios.master.HostStillInUseException;
import com.spotify.helios.master.JobAlreadyDeployedException;
import com.spotify.helios.master.JobDoesNotExistException;
import com.spotify.helios.master.JobExistsException;
import com.spotify.helios.master.JobNotDeployedException;
import com.spotify.helios.master.JobPortAllocationConflictException;
import com.spotify.helios.master.JobStillDeployedException;
import com.spotify.helios.master.MasterModel;
import com.spotify.helios.master.TokenVerificationException;
import com.spotify.helios.rollingupdate.DeploymentGroupEventFactory;
import com.spotify.helios.rollingupdate.RollingUndeployPlanner;
import com.spotify.helios.rollingupdate.RollingUpdateError;
import com.spotify.helios.rollingupdate.RollingUpdateOp;
import com.spotify.helios.rollingupdate.RollingUpdateOpFactory;
import com.spotify.helios.rollingupdate.RollingUpdatePlanner;
import com.spotify.helios.servicescommon.EventSender;
import com.spotify.helios.servicescommon.VersionedValue;
import com.spotify.helios.servicescommon.ZooKeeperRegistrarUtil;
import com.spotify.helios.servicescommon.coordination.Node;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClientProvider;
import com.spotify.helios.servicescommon.coordination.ZooKeeperOperation;
import com.spotify.helios.servicescommon.coordination.ZooKeeperOperations;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.data.Stat;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperMasterModel
implements MasterModel {
    private static final Comparator<TaskStatusEvent> EVENT_COMPARATOR = new Comparator<TaskStatusEvent>(){

        @Override
        public int compare(TaskStatusEvent arg0, TaskStatusEvent arg1) {
            if (arg1.getTimestamp() > arg0.getTimestamp()) {
                return -1;
            }
            if (arg1.getTimestamp() == arg0.getTimestamp()) {
                return 0;
            }
            return 1;
        }
    };
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperMasterModel.class);
    public static final Map<JobId, TaskStatus> EMPTY_STATUSES = Collections.emptyMap();
    public static final TypeReference<HostInfo> HOST_INFO_TYPE = new TypeReference<HostInfo>(){};
    public static final TypeReference<AgentInfo> AGENT_INFO_TYPE = new TypeReference<AgentInfo>(){};
    public static final TypeReference<Map<String, String>> STRING_MAP_TYPE = new TypeReference<Map<String, String>>(){};
    public static final TypeReference<List<String>> STRING_LIST_TYPE = new TypeReference<List<String>>(){};
    private static final String DEPLOYMENT_GROUP_EVENT_TOPIC = "HeliosDeploymentGroupEvents";
    private static final DeploymentGroupEventFactory DEPLOYMENT_GROUP_EVENT_FACTORY = new DeploymentGroupEventFactory();
    private final ZooKeeperClientProvider provider;
    private final String name;
    private final List<EventSender> eventSenders;

    public ZooKeeperMasterModel(ZooKeeperClientProvider provider, String name, List<EventSender> eventSenders) {
        this.provider = (ZooKeeperClientProvider)Preconditions.checkNotNull((Object)provider);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.eventSenders = (List)Preconditions.checkNotNull(eventSenders);
    }

    @Override
    public void registerHost(String host, String id) {
        ZooKeeperClient client = this.provider.get("registerHost");
        try {
            ZooKeeperRegistrarUtil.registerHost(client, Paths.configHostId(host), host, id);
        }
        catch (Exception e) {
            throw new HeliosRuntimeException("registering host " + host + " failed", (Throwable)e);
        }
    }

    @Override
    public List<String> listHosts() {
        try {
            return this.provider.get("listHosts").getChildren(Paths.configHosts());
        }
        catch (KeeperException.NoNodeException e) {
            return Collections.emptyList();
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("listing hosts failed", (Throwable)e);
        }
    }

    @Override
    public List<String> getRunningMasters() {
        ZooKeeperClient client = this.provider.get("getRunningMasters");
        try {
            List<String> masters = client.getChildren(Paths.statusMaster());
            ImmutableList.Builder upMasters = ImmutableList.builder();
            for (String master : masters) {
                if (client.exists(Paths.statusMasterUp(master)) == null) continue;
                upMasters.add((Object)master);
            }
            return upMasters.build();
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("listing masters failed", (Throwable)e);
        }
    }

    @Override
    public void deregisterHost(String host) throws HostNotFoundException, HostStillInUseException {
        ZooKeeperClient client = this.provider.get("deregisterHost");
        ZooKeeperRegistrarUtil.deregisterHost(client, host);
    }

    @Override
    public void addJob(Job job) throws JobExistsException {
        log.info("adding job: {}", (Object)job);
        JobId id = job.getId();
        UUID operationId = UUID.randomUUID();
        String creationPath = Paths.configJobCreation(id, operationId);
        ZooKeeperClient client = this.provider.get("addJob");
        try {
            try {
                client.ensurePath(Paths.historyJob(id));
                client.transaction(ZooKeeperOperations.create(Paths.configJob(id), (Descriptor)job), ZooKeeperOperations.create(Paths.configJobRefShort(id), (Descriptor)id), ZooKeeperOperations.create(Paths.configJobHosts(id)), ZooKeeperOperations.create(creationPath), ZooKeeperOperations.set(Paths.configJobs(), UUID.randomUUID().toString().getBytes()));
            }
            catch (KeeperException.NodeExistsException e) {
                if (client.exists(creationPath) != null) {
                    return;
                }
                throw new JobExistsException(id.toString());
            }
        }
        catch (KeeperException.NoNodeException e) {
            throw new HeliosRuntimeException("adding job " + job + " failed due to missing ZK path: " + e.getPath(), (Throwable)e);
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("adding job " + job + " failed", (Throwable)e);
        }
    }

    @Override
    public List<TaskStatusEvent> getJobHistory(JobId jobId) throws JobDoesNotExistException {
        return this.getJobHistory(jobId, null);
    }

    @Override
    public List<TaskStatusEvent> getJobHistory(JobId jobId, String host) throws JobDoesNotExistException {
        List<String> hosts;
        Job descriptor = this.getJob(jobId);
        if (descriptor == null) {
            throw new JobDoesNotExistException(jobId);
        }
        ZooKeeperClient client = this.provider.get("getJobHistory");
        try {
            hosts = !Strings.isNullOrEmpty((String)host) ? Collections.singletonList(host) : client.getChildren(Paths.historyJobHosts(jobId));
        }
        catch (KeeperException.NoNodeException e) {
            return Collections.emptyList();
        }
        catch (KeeperException e) {
            throw Throwables.propagate((Throwable)e);
        }
        ArrayList jsEvents = Lists.newArrayList();
        for (String h : hosts) {
            List<String> events;
            try {
                events = client.getChildren(Paths.historyJobHostEvents(jobId, h));
            }
            catch (KeeperException.NoNodeException e) {
                continue;
            }
            catch (KeeperException e) {
                throw Throwables.propagate((Throwable)e);
            }
            for (String event : events) {
                try {
                    byte[] data = client.getData(Paths.historyJobHostEventsTimestamp(jobId, h, Long.valueOf(event)));
                    TaskStatus status = (TaskStatus)Json.read((byte[])data, TaskStatus.class);
                    jsEvents.add(new TaskStatusEvent(status, Long.valueOf(event).longValue(), h));
                }
                catch (KeeperException.NoNodeException data) {
                }
                catch (IOException | KeeperException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }
        return Ordering.from(EVENT_COMPARATOR).sortedCopy((Iterable)jsEvents);
    }

    @Override
    public void addDeploymentGroup(DeploymentGroup deploymentGroup) throws DeploymentGroupExistsException {
        log.info("adding deployment-group: {}", (Object)deploymentGroup);
        ZooKeeperClient client = this.provider.get("addDeploymentGroup");
        try {
            try {
                client.ensurePath(Paths.configDeploymentGroups());
                client.ensurePath(Paths.statusDeploymentGroups());
                client.transaction(ZooKeeperOperations.create(Paths.configDeploymentGroup(deploymentGroup.getName()), (Descriptor)deploymentGroup), ZooKeeperOperations.create(Paths.statusDeploymentGroup(deploymentGroup.getName())), ZooKeeperOperations.create(Paths.statusDeploymentGroupHosts(deploymentGroup.getName()), Json.asBytesUnchecked(Collections.emptyList())), ZooKeeperOperations.create(Paths.statusDeploymentGroupRemovedHosts(deploymentGroup.getName()), Json.asBytesUnchecked(Collections.emptyList())));
            }
            catch (KeeperException.NodeExistsException e) {
                throw new DeploymentGroupExistsException(deploymentGroup.getName());
            }
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("adding deployment-group " + deploymentGroup + " failed", (Throwable)e);
        }
    }

    @Override
    public DeploymentGroup getDeploymentGroup(String name) throws DeploymentGroupDoesNotExistException {
        log.debug("getting deployment-group: {}", (Object)name);
        ZooKeeperClient client = this.provider.get("getDeploymentGroup");
        return this.getDeploymentGroup(client, name);
    }

    private DeploymentGroup getDeploymentGroup(ZooKeeperClient client, String name) throws DeploymentGroupDoesNotExistException {
        try {
            byte[] data = client.getData(Paths.configDeploymentGroup(name));
            return (DeploymentGroup)Json.read((byte[])data, DeploymentGroup.class);
        }
        catch (KeeperException.NoNodeException e) {
            throw new DeploymentGroupDoesNotExistException(name);
        }
        catch (IOException | KeeperException e) {
            throw new HeliosRuntimeException("getting deployment-group " + name + " failed", e);
        }
    }

    @Override
    public void removeDeploymentGroup(String name) throws DeploymentGroupDoesNotExistException {
        log.info("removing deployment-group: name={}", (Object)name);
        ZooKeeperClient client = this.provider.get("removeDeploymentGroup");
        try {
            client.ensurePath(Paths.configDeploymentGroups());
            client.ensurePath(Paths.statusDeploymentGroups());
            client.ensurePath(Paths.statusDeploymentGroupTasks());
            ArrayList operations = Lists.newArrayList();
            ImmutableList paths = ImmutableList.of((Object)Paths.configDeploymentGroup(name), (Object)Paths.statusDeploymentGroup(name), (Object)Paths.statusDeploymentGroupHosts(name), (Object)Paths.statusDeploymentGroupRemovedHosts(name), (Object)Paths.statusDeploymentGroupTasks(name));
            for (String path : paths) {
                if (client.exists(path) != null) continue;
                operations.add(ZooKeeperOperations.create(path));
            }
            for (String path : Lists.reverse((List)paths)) {
                operations.add(ZooKeeperOperations.delete(path));
            }
            client.transaction(operations);
        }
        catch (KeeperException.NoNodeException e) {
            throw new DeploymentGroupDoesNotExistException(name);
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("removing deployment-group " + name + " failed", (Throwable)e);
        }
    }

    private boolean allowHostChange(DeploymentGroupStatus status) {
        if (status == null) {
            return true;
        }
        return status.getState() != DeploymentGroupStatus.State.ROLLING_OUT;
    }

    private boolean updateOnHostChange(DeploymentGroup group, DeploymentGroupStatus status) {
        if (status == null) {
            return true;
        }
        if (group.getRollingUpdateReason() == null) {
            return status.getState() != DeploymentGroupStatus.State.FAILED;
        }
        if (group.getRollingUpdateReason() == DeploymentGroup.RollingUpdateReason.HOSTS_CHANGED && status.getState() == DeploymentGroupStatus.State.FAILED) {
            return true;
        }
        return status.getState() != DeploymentGroupStatus.State.FAILED;
    }

    private List<String> removedHosts(List<String> currentHosts, List<String> newHosts, List<String> previouslyRemovedHosts) {
        ImmutableSet ch = ImmutableSet.copyOf(currentHosts);
        ImmutableSet nh = ImmutableSet.copyOf(newHosts);
        ImmutableSet prh = ImmutableSet.copyOf(previouslyRemovedHosts);
        return ImmutableList.copyOf((Collection)Sets.union((Set)Sets.difference((Set)ch, (Set)nh), (Set)prh));
    }

    @Override
    public void updateDeploymentGroupHosts(String groupName, List<String> hosts) throws DeploymentGroupDoesNotExistException {
        log.debug("updating deployment-group hosts: name={}", (Object)groupName);
        ZooKeeperClient client = this.provider.get("updateDeploymentGroupHosts");
        try {
            DeploymentGroupStatus status = this.getDeploymentGroupStatus(groupName);
            if (!this.allowHostChange(status)) {
                return;
            }
            client.ensurePathAndSetData(Paths.statusDeploymentGroupRemovedHosts(groupName), Json.asBytesUnchecked(Collections.emptyList()));
            List<String> curHosts = this.getHosts(client, Paths.statusDeploymentGroupHosts(groupName));
            List<String> previouslyRemovedHosts = this.getHosts(client, Paths.statusDeploymentGroupRemovedHosts(groupName));
            if (hosts.equals(curHosts)) {
                return;
            }
            List<String> removedHosts = this.removedHosts(curHosts, hosts, previouslyRemovedHosts);
            log.info("for deployment-group name={}, curHosts={}, new hosts={}, previouslyRemovedHosts={}, derived removedHosts={}", new Object[]{groupName, curHosts, hosts, previouslyRemovedHosts, removedHosts});
            ArrayList ops = Lists.newArrayList();
            ops.add(ZooKeeperOperations.set(Paths.statusDeploymentGroupHosts(groupName), Json.asBytes(hosts)));
            ops.add(ZooKeeperOperations.set(Paths.statusDeploymentGroupRemovedHosts(groupName), Json.asBytes(removedHosts)));
            Node dgn = client.getNode(Paths.configDeploymentGroup(groupName));
            Integer deploymentGroupVersion = dgn.getStat().getVersion();
            DeploymentGroup deploymentGroup = (DeploymentGroup)Json.read((byte[])dgn.getBytes(), DeploymentGroup.class);
            ImmutableList<Map<String, Object>> events = ImmutableList.of();
            if (deploymentGroup.getJobId() != null && this.updateOnHostChange(deploymentGroup, status)) {
                deploymentGroup = deploymentGroup.toBuilder().setRollingUpdateReason(DeploymentGroup.RollingUpdateReason.HOSTS_CHANGED).build();
                ops.add(ZooKeeperOperations.check(Paths.configDeploymentGroup(groupName), deploymentGroupVersion));
                ops.add(ZooKeeperOperations.set(Paths.configDeploymentGroup(deploymentGroup.getName()), (Descriptor)deploymentGroup));
                RollingUpdateOp op = this.getInitRollingUpdateOps(deploymentGroup, hosts, removedHosts, client);
                ops.addAll(op.operations());
                events = op.events();
            }
            log.info("starting zookeeper transaction for updateDeploymentGroupHosts on deployment-group: name={} jobId={} operations={}", new Object[]{groupName, deploymentGroup.getJobId(), ops});
            client.transaction(ops);
            this.emitEvents(DEPLOYMENT_GROUP_EVENT_TOPIC, (List<Map<String, Object>>)events);
        }
        catch (KeeperException.BadVersionException e) {
            log.info("zookeeper transaction for updateDeploymentGroupHosts on deployment-group was processed by another master: name={}", (Object)groupName);
        }
        catch (KeeperException.NoNodeException e) {
            throw new DeploymentGroupDoesNotExistException(groupName, e);
        }
        catch (IOException | KeeperException e) {
            throw new HeliosRuntimeException("updating deployment group hosts failed", e);
        }
    }

    @Override
    public void rollingUpdate(DeploymentGroup deploymentGroup, JobId jobId, RolloutOptions options) throws DeploymentGroupDoesNotExistException, JobDoesNotExistException {
        Preconditions.checkNotNull((Object)deploymentGroup, (Object)"deploymentGroup");
        log.info("preparing to initiate rolling-update on deployment-group: name={}, jobId={}", (Object)deploymentGroup.getName(), (Object)jobId);
        DeploymentGroup updated = deploymentGroup.toBuilder().setJobId(jobId).setRolloutOptions(options).setRollingUpdateReason(DeploymentGroup.RollingUpdateReason.MANUAL).build();
        if (this.getJob(jobId) == null) {
            throw new JobDoesNotExistException(jobId);
        }
        ArrayList operations = Lists.newArrayList();
        ZooKeeperClient client = this.provider.get("rollingUpdate");
        operations.add(ZooKeeperOperations.set(Paths.configDeploymentGroup(updated.getName()), (Descriptor)updated));
        try {
            RollingUpdateOp op = this.getInitRollingUpdateOps(updated, client);
            operations.addAll(op.operations());
            log.info("starting zookeeper transaction for rolling-update on deployment-group name={} jobId={}. List of operations: {}", new Object[]{deploymentGroup.getName(), jobId, operations});
            client.transaction(operations);
            this.emitEvents(DEPLOYMENT_GROUP_EVENT_TOPIC, (List<Map<String, Object>>)op.events());
            log.info("initiated rolling-update on deployment-group: name={}, jobId={}", (Object)deploymentGroup.getName(), (Object)jobId);
        }
        catch (KeeperException.NoNodeException e) {
            throw new DeploymentGroupDoesNotExistException(deploymentGroup.getName());
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("rolling-update on deployment-group " + deploymentGroup.getName() + " failed", (Throwable)e);
        }
    }

    private RollingUpdateOp getInitRollingUpdateOps(DeploymentGroup deploymentGroup, ZooKeeperClient zooKeeperClient) throws DeploymentGroupDoesNotExistException, KeeperException {
        List<String> hosts = this.getDeploymentGroupHosts(deploymentGroup.getName());
        return this.getInitRollingUpdateOps(deploymentGroup, hosts, (List<String>)ImmutableList.of(), zooKeeperClient);
    }

    private RollingUpdateOp getInitRollingUpdateOps(DeploymentGroup deploymentGroup, List<String> updateHosts, List<String> undeployHosts, ZooKeeperClient zooKeeperClient) throws KeeperException {
        ArrayList<RolloutTask> rolloutTasks = new ArrayList<RolloutTask>();
        ArrayList<String> updateHostsCopy = new ArrayList<String>(updateHosts);
        ArrayList<String> undeployHostsCopy = new ArrayList<String>(undeployHosts);
        undeployHostsCopy.removeAll(updateHostsCopy);
        rolloutTasks.addAll(RollingUndeployPlanner.of(deploymentGroup).plan(this.getHostStatuses(undeployHostsCopy)));
        rolloutTasks.addAll(RollingUpdatePlanner.of(deploymentGroup).plan(this.getHostStatuses(updateHostsCopy)));
        log.info("generated rolloutTasks for deployment-group name={} updateHosts={} undeployHosts={}: {}", new Object[]{deploymentGroup.getName(), updateHosts, undeployHosts, rolloutTasks});
        DeploymentGroupTasks tasks = DeploymentGroupTasks.newBuilder().setRolloutTasks(rolloutTasks).setTaskIndex(0).setDeploymentGroup(deploymentGroup).build();
        return new RollingUpdateOpFactory(tasks, DEPLOYMENT_GROUP_EVENT_FACTORY).start(deploymentGroup, zooKeeperClient);
    }

    private Map<String, HostStatus> getHostStatuses(List<String> hosts) {
        ImmutableMap.Builder hostsAndStatuses = ImmutableMap.builder();
        hosts.forEach(host -> {
            HostStatus status = this.getHostStatus((String)host);
            if (status != null) {
                hostsAndStatuses.put(host, (Object)status);
            }
        });
        return hostsAndStatuses.build();
    }

    private Map<String, VersionedValue<DeploymentGroupTasks>> getDeploymentGroupTasks(ZooKeeperClient client) {
        String folder = Paths.statusDeploymentGroupTasks();
        try {
            List<String> names;
            try {
                names = client.getChildren(folder);
            }
            catch (KeeperException.NoNodeException e) {
                return Collections.emptyMap();
            }
            HashMap ret = Maps.newHashMap();
            for (String name : names) {
                String path = Paths.statusDeploymentGroupTasks(name);
                try {
                    Node node = client.getNode(path);
                    byte[] data = node.getBytes();
                    int version = node.getStat().getVersion();
                    if (data.length == 0) {
                        log.debug("Ignoring empty deployment group tasks {}", (Object)name);
                        continue;
                    }
                    DeploymentGroupTasks val = (DeploymentGroupTasks)Descriptor.parse((byte[])data, DeploymentGroupTasks.class);
                    ret.put(name, VersionedValue.of(val, version));
                }
                catch (KeeperException.NoNodeException e) {
                    log.debug("Ignoring deleted deployment group tasks {}", (Object)name);
                }
            }
            return ret;
        }
        catch (IOException | KeeperException e) {
            throw new HeliosRuntimeException("getting deployment group tasks failed", e);
        }
    }

    private RollingUpdateOp processRollingUpdateTask(ZooKeeperClient client, RollingUpdateOpFactory opFactory, RolloutTask task, DeploymentGroup deploymentGroup) {
        RolloutTask.Action action = task.getAction();
        String host = task.getTarget();
        switch (action) {
            case UNDEPLOY_OLD_JOBS: {
                return this.rollingUpdateUndeploy(client, opFactory, deploymentGroup, host);
            }
            case DEPLOY_NEW_JOB: {
                return this.rollingUpdateDeploy(client, opFactory, deploymentGroup, host);
            }
            case AWAIT_RUNNING: {
                return this.rollingUpdateAwaitRunning(client, opFactory, deploymentGroup, host);
            }
            case FORCE_UNDEPLOY_JOBS: {
                return this.forceRollingUpdateUndeploy(client, opFactory, deploymentGroup, host);
            }
            case AWAIT_UNDEPLOYED: {
                return this.rollingUpdateAwaitUndeployed(client, opFactory, deploymentGroup, host);
            }
            case MARK_UNDEPLOYED: {
                return this.rollingUpdateMarkUndeployed(client, opFactory, deploymentGroup, host);
            }
        }
        throw new HeliosRuntimeException(String.format("unknown rollout task type %s for deployment group %s.", action, deploymentGroup.getName()));
    }

    @Override
    public void rollingUpdateStep() {
        ZooKeeperClient client = this.provider.get("rollingUpdateStep");
        Map<String, VersionedValue<DeploymentGroupTasks>> tasksMap = this.getDeploymentGroupTasks(client);
        for (Map.Entry<String, VersionedValue<DeploymentGroupTasks>> entry : tasksMap.entrySet()) {
            String deploymentGroupName = entry.getKey();
            VersionedValue<DeploymentGroupTasks> versionedTasks = entry.getValue();
            DeploymentGroupTasks tasks = versionedTasks.value();
            log.info("rolling-update step on deployment-group: name={}, tasks={}", (Object)deploymentGroupName, (Object)tasks);
            try {
                RollingUpdateOpFactory opFactory = new RollingUpdateOpFactory(tasks, DEPLOYMENT_GROUP_EVENT_FACTORY);
                RolloutTask task = (RolloutTask)tasks.getRolloutTasks().get(tasks.getTaskIndex());
                RollingUpdateOp op = this.processRollingUpdateTask(client, opFactory, task, tasks.getDeploymentGroup());
                if (op.operations().isEmpty()) continue;
                ArrayList ops = Lists.newArrayList();
                ops.add(ZooKeeperOperations.check(Paths.statusDeploymentGroupTasks(deploymentGroupName), versionedTasks.version()));
                ops.addAll(op.operations());
                log.info("rolling-update step on deployment-group: name={}, zookeeper operations={}", (Object)deploymentGroupName, (Object)ops);
                try {
                    client.transaction(ops);
                    this.emitEvents(DEPLOYMENT_GROUP_EVENT_TOPIC, (List<Map<String, Object>>)op.events());
                }
                catch (KeeperException.BadVersionException e) {
                    log.info("rolling-update step on deployment-group was processed by another master: name={}, zookeeper operations={}", (Object)deploymentGroupName, (Object)ops);
                }
                catch (KeeperException e) {
                    log.error("rolling-update on deployment-group {} failed", (Object)deploymentGroupName, (Object)e);
                }
            }
            catch (Exception e) {
                log.error("error processing rolling update step for {}", (Object)deploymentGroupName, (Object)e);
            }
        }
    }

    private void emitEvents(String topic, List<Map<String, Object>> events) {
        for (Map<String, Object> event : events) {
            byte[] message = Json.asBytesUnchecked(event);
            for (EventSender sender : this.eventSenders) {
                sender.send(topic, message);
            }
        }
    }

    private RollingUpdateOp rollingUpdateTimedoutError(RollingUpdateOpFactory opFactory, String host, JobId jobId, TaskStatus taskStatus) {
        List<TaskStatus.State> previousJobStates = this.getPreviousJobStates(jobId, host, 10);
        String baseError = "timed out waiting for job " + jobId + " to reach state RUNNING ";
        String stateInfo = String.format("(terminal job state %s, previous states: %s)", taskStatus.getState(), Joiner.on((String)"->").join(previousJobStates));
        HashMap metadata = Maps.newHashMap();
        metadata.put("jobState", taskStatus.getState());
        metadata.put("previousJobStates", previousJobStates);
        metadata.put("throttleState", taskStatus.getThrottled());
        if (taskStatus.getThrottled().equals((Object)ThrottleState.IMAGE_MISSING)) {
            return opFactory.error(baseError + "due to missing Docker image " + stateInfo, host, RollingUpdateError.IMAGE_MISSING, metadata);
        }
        if (taskStatus.getThrottled().equals((Object)ThrottleState.IMAGE_PULL_FAILED)) {
            return opFactory.error(baseError + "due to failure pulling Docker image " + stateInfo, host, RollingUpdateError.IMAGE_PULL_FAILED, metadata);
        }
        if (!Strings.isNullOrEmpty((String)taskStatus.getContainerError())) {
            return opFactory.error(baseError + stateInfo + " container error: " + taskStatus.getContainerError(), host, RollingUpdateError.TIMED_OUT_WAITING_FOR_JOB_TO_REACH_RUNNING, metadata);
        }
        return opFactory.error(baseError + stateInfo, host, RollingUpdateError.TIMED_OUT_WAITING_FOR_JOB_TO_REACH_RUNNING, metadata);
    }

    private RollingUpdateOp rollingUpdateAwaitRunning(ZooKeeperClient client, RollingUpdateOpFactory opFactory, DeploymentGroup deploymentGroup, String host) {
        TaskStatus taskStatus = this.getTaskStatus(client, host, deploymentGroup.getJobId());
        JobId jobId = deploymentGroup.getJobId();
        if (taskStatus == null) {
            Deployment deployment = this.getDeployment(host, jobId);
            if (deployment == null) {
                return opFactory.error("Job unexpectedly undeployed. Perhaps it was manually undeployed?", host, RollingUpdateError.JOB_UNEXPECTEDLY_UNDEPLOYED);
            }
            if (this.isRolloutTimedOut(client, deploymentGroup)) {
                return opFactory.error("timed out while retrieving job status", host, RollingUpdateError.TIMED_OUT_RETRIEVING_JOB_STATUS);
            }
            return opFactory.yield();
        }
        if (!taskStatus.getState().equals((Object)TaskStatus.State.RUNNING)) {
            if (this.isRolloutTimedOut(client, deploymentGroup)) {
                return this.rollingUpdateTimedoutError(opFactory, host, jobId, taskStatus);
            }
            return opFactory.yield();
        }
        Deployment deployment = this.getDeployment(host, deploymentGroup.getJobId());
        if (deployment == null) {
            return opFactory.error("deployment for this job not found in zookeeper. Perhaps it was manually undeployed?", host, RollingUpdateError.JOB_UNEXPECTEDLY_UNDEPLOYED);
        }
        if (!Objects.equals(deployment.getDeploymentGroupName(), deploymentGroup.getName())) {
            return opFactory.error("job was already deployed, either manually or by a different deployment group", host, RollingUpdateError.JOB_ALREADY_DEPLOYED);
        }
        return opFactory.nextTask();
    }

    private boolean isRolloutTimedOut(ZooKeeperClient client, DeploymentGroup deploymentGroup) {
        try {
            String statusPath = Paths.statusDeploymentGroupTasks(deploymentGroup.getName());
            long secondsSinceDeploy = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - client.getNode(statusPath).getStat().getMtime());
            return secondsSinceDeploy > deploymentGroup.getRolloutOptions().getTimeout();
        }
        catch (KeeperException e) {
            log.warn("error determining deployment group modification time: {} - {}", (Object)deploymentGroup.getName(), (Object)e);
            return false;
        }
    }

    private RollingUpdateOp rollingUpdateDeploy(ZooKeeperClient client, RollingUpdateOpFactory opFactory, DeploymentGroup deploymentGroup, String host) {
        Deployment deployment = Deployment.of((JobId)deploymentGroup.getJobId(), (Goal)Goal.START, (String)Deployment.EMTPY_DEPLOYER_USER, (String)this.name, (String)deploymentGroup.getName());
        try {
            String token = (String)MoreObjects.firstNonNull((Object)deploymentGroup.getRolloutOptions().getToken(), (Object)"");
            return opFactory.nextTask(this.getDeployOperations(client, host, deployment, token));
        }
        catch (JobDoesNotExistException e) {
            return opFactory.error((Exception)((Object)e), host, RollingUpdateError.JOB_NOT_FOUND);
        }
        catch (TokenVerificationException e) {
            return opFactory.error((Exception)((Object)e), host, RollingUpdateError.TOKEN_VERIFICATION_ERROR);
        }
        catch (HostNotFoundException e) {
            return opFactory.error((Exception)((Object)e), host, RollingUpdateError.HOST_NOT_FOUND);
        }
        catch (JobPortAllocationConflictException e) {
            return opFactory.error((Exception)((Object)e), host, RollingUpdateError.PORT_CONFLICT);
        }
        catch (JobAlreadyDeployedException e) {
            return opFactory.nextTask();
        }
    }

    private RollingUpdateOp rollingUpdateAwaitUndeployed(ZooKeeperClient client, RollingUpdateOpFactory opFactory, DeploymentGroup deploymentGroup, String host) {
        TaskStatus taskStatus = this.getTaskStatus(client, host, deploymentGroup.getJobId());
        if (taskStatus == null) {
            return opFactory.nextTask();
        }
        if (this.isRolloutTimedOut(client, deploymentGroup)) {
            return opFactory.error("timed out while waiting for job undeployment", host, RollingUpdateError.TIMED_OUT_WAITING_FOR_JOB_TO_UNDEPLOY);
        }
        return opFactory.yield();
    }

    private RollingUpdateOp rollingUpdateMarkUndeployed(ZooKeeperClient client, RollingUpdateOpFactory opFactory, DeploymentGroup deploymentGroup, String host) {
        try {
            Node node = client.getNode(Paths.statusDeploymentGroupRemovedHosts(deploymentGroup.getName()));
            int version = node.getStat().getVersion();
            List hostsToUndeploy = (List)Json.read((byte[])node.getBytes(), STRING_LIST_TYPE);
            if (!hostsToUndeploy.remove(host)) {
                return opFactory.nextTask();
            }
            return opFactory.nextTask((List<ZooKeeperOperation>)ImmutableList.of((Object)ZooKeeperOperations.check(Paths.statusDeploymentGroupRemovedHosts(deploymentGroup.getName()), version), (Object)ZooKeeperOperations.set(Paths.statusDeploymentGroupRemovedHosts(deploymentGroup.getName()), Json.asBytes((Object)hostsToUndeploy))));
        }
        catch (IOException | KeeperException e) {
            return opFactory.error("unable to mark host undeployed after removal from deployment group", host, RollingUpdateError.UNABLE_TO_MARK_HOST_UNDEPLOYED);
        }
    }

    private RollingUpdateOp rollingUpdateUndeploy(ZooKeeperClient client, RollingUpdateOpFactory opFactory, DeploymentGroup deploymentGroup, String host) {
        return this.rollingUpdateUndeploy(client, opFactory, deploymentGroup, host, true);
    }

    private RollingUpdateOp forceRollingUpdateUndeploy(ZooKeeperClient client, RollingUpdateOpFactory opFactory, DeploymentGroup deploymentGroup, String host) {
        return this.rollingUpdateUndeploy(client, opFactory, deploymentGroup, host, false);
    }

    private RollingUpdateOp rollingUpdateUndeploy(ZooKeeperClient client, RollingUpdateOpFactory opFactory, DeploymentGroup deploymentGroup, String host, boolean skipRedundantUndeploys) {
        ArrayList operations = Lists.newArrayList();
        for (Deployment deployment : this.getTasks(client, host).values()) {
            if (!this.ownedByDeploymentGroup(deployment, deploymentGroup) && !this.isMigration(deployment, deploymentGroup) || skipRedundantUndeploys && this.redundantUndeployment(deployment, deploymentGroup)) continue;
            try {
                String token = (String)MoreObjects.firstNonNull((Object)deploymentGroup.getRolloutOptions().getToken(), (Object)"");
                operations.addAll(this.getUndeployOperations(client, host, deployment.getJobId(), token));
                log.debug("planned undeploy operations for job={}", (Object)deployment.getJobId());
            }
            catch (TokenVerificationException e) {
                return opFactory.error((Exception)((Object)e), host, RollingUpdateError.TOKEN_VERIFICATION_ERROR);
            }
            catch (HostNotFoundException e) {
                return opFactory.error((Exception)((Object)e), host, RollingUpdateError.HOST_NOT_FOUND);
            }
            catch (JobNotDeployedException jobNotDeployedException) {
            }
        }
        return opFactory.nextTask(operations);
    }

    private boolean ownedByDeploymentGroup(Deployment deployment, DeploymentGroup deploymentGroup) {
        return Objects.equals(deployment.getDeploymentGroupName(), deploymentGroup.getName());
    }

    private boolean isMigration(Deployment deployment, DeploymentGroup deploymentGroup) {
        return deploymentGroup.getRolloutOptions().getMigrate() && deployment.getJobId().equals((Object)deploymentGroup.getJobId());
    }

    private boolean redundantUndeployment(Deployment deployment, DeploymentGroup deploymentGroup) {
        if (!Objects.equals(deployment.getDeploymentGroupName(), deploymentGroup.getName())) {
            return false;
        }
        if (!deployment.getJobId().equals((Object)deploymentGroup.getJobId())) {
            return false;
        }
        return Goal.START.equals((Object)deployment.getGoal());
    }

    @Override
    public void stopDeploymentGroup(String deploymentGroupName) throws DeploymentGroupDoesNotExistException {
        Preconditions.checkNotNull((Object)deploymentGroupName, (Object)"name");
        log.info("stop deployment-group: name={}", (Object)deploymentGroupName);
        ZooKeeperClient client = this.provider.get("stopDeploymentGroup");
        DeploymentGroupStatus status = DeploymentGroupStatus.newBuilder().setState(DeploymentGroupStatus.State.FAILED).setError("Stopped by user").build();
        String statusPath = Paths.statusDeploymentGroup(deploymentGroupName);
        String tasksPath = Paths.statusDeploymentGroupTasks(deploymentGroupName);
        try {
            client.ensurePath(Paths.statusDeploymentGroupTasks());
            ArrayList operations = Lists.newArrayList();
            operations.add(ZooKeeperOperations.set(statusPath, (Descriptor)status));
            Stat tasksStat = client.exists(tasksPath);
            if (tasksStat != null) {
                operations.add(ZooKeeperOperations.delete(tasksPath));
            } else {
                operations.add(ZooKeeperOperations.create(tasksPath));
                operations.add(ZooKeeperOperations.delete(tasksPath));
            }
            client.transaction(operations);
        }
        catch (KeeperException.NoNodeException e) {
            if (((OpResult.ErrorResult)e.getResults().get(0)).getErr() == KeeperException.Code.NONODE.intValue()) {
                throw new DeploymentGroupDoesNotExistException(deploymentGroupName);
            }
            throw new HeliosRuntimeException("stop deployment-group " + deploymentGroupName + " failed due to a race condition, please retry", (Throwable)e);
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("stop deployment-group " + deploymentGroupName + " failed", (Throwable)e);
        }
    }

    @Override
    public Map<String, DeploymentGroup> getDeploymentGroups() {
        log.debug("getting deployment groups");
        String folder = Paths.configDeploymentGroups();
        ZooKeeperClient client = this.provider.get("getDeploymentGroups");
        try {
            List<String> names;
            try {
                names = client.getChildren(folder);
            }
            catch (KeeperException.NoNodeException e) {
                return Maps.newHashMap();
            }
            HashMap descriptors = Maps.newHashMap();
            for (String name : names) {
                String path = Paths.configDeploymentGroup(name);
                try {
                    byte[] data = client.getData(path);
                    DeploymentGroup descriptor = (DeploymentGroup)Descriptor.parse((byte[])data, DeploymentGroup.class);
                    descriptors.put(descriptor.getName(), descriptor);
                }
                catch (KeeperException.NoNodeException e) {
                    log.debug("Ignoring deleted deployment group {}", (Object)name);
                }
            }
            return descriptors;
        }
        catch (IOException | KeeperException e) {
            throw new HeliosRuntimeException("getting deployment groups failed", e);
        }
    }

    @Override
    public DeploymentGroupStatus getDeploymentGroupStatus(String name) throws DeploymentGroupDoesNotExistException {
        log.debug("getting deployment group status: {}", (Object)name);
        ZooKeeperClient client = this.provider.get("getDeploymentGroupStatus");
        DeploymentGroup deploymentGroup = this.getDeploymentGroup(client, name);
        if (deploymentGroup == null) {
            return null;
        }
        try {
            Node node = client.getNode(Paths.statusDeploymentGroup(name));
            byte[] bytes = node.getBytes();
            if (bytes.length == 0) {
                return null;
            }
            return (DeploymentGroupStatus)Json.read((byte[])bytes, DeploymentGroupStatus.class);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (IOException | KeeperException e) {
            throw new HeliosRuntimeException("getting deployment group status " + name + " failed", e);
        }
    }

    private List<String> getHosts(ZooKeeperClient client, String path) {
        try {
            return (List)Json.read((byte[])client.getNode(path).getBytes(), STRING_LIST_TYPE);
        }
        catch (JsonParseException | JsonMappingException | KeeperException.NoNodeException e) {
            return Collections.emptyList();
        }
        catch (IOException | KeeperException e) {
            throw new HeliosRuntimeException("failed to read deployment group hosts from " + path, e);
        }
    }

    @Override
    public List<String> getDeploymentGroupHosts(String name) throws DeploymentGroupDoesNotExistException {
        log.debug("getting deployment group hosts: {}", (Object)name);
        ZooKeeperClient client = this.provider.get("getDeploymentGroupHosts");
        DeploymentGroup deploymentGroup = this.getDeploymentGroup(client, name);
        if (deploymentGroup == null) {
            throw new DeploymentGroupDoesNotExistException(name);
        }
        return this.getHosts(client, Paths.statusDeploymentGroupHosts(name));
    }

    @Override
    public Job getJob(JobId id) {
        log.debug("getting job: {}", (Object)id);
        ZooKeeperClient client = this.provider.get("getJobId");
        return this.getJob(client, id);
    }

    private Job getJob(ZooKeeperClient client, JobId id) {
        String path = Paths.configJob(id);
        try {
            byte[] data = client.getData(path);
            return (Job)Json.read((byte[])data, Job.class);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (IOException | KeeperException e) {
            throw new HeliosRuntimeException("getting job " + id + " failed", e);
        }
    }

    @Override
    public Map<JobId, Job> getJobs() {
        log.debug("getting jobs");
        String folder = Paths.configJobs();
        ZooKeeperClient client = this.provider.get("getJobs");
        try {
            List<String> ids;
            try {
                ids = client.getChildren(folder);
            }
            catch (KeeperException.NoNodeException e) {
                return Maps.newHashMap();
            }
            HashMap descriptors = Maps.newHashMap();
            for (String id : ids) {
                JobId jobId = JobId.fromString((String)id);
                String path = Paths.configJob(jobId);
                try {
                    byte[] data = client.getData(path);
                    Job descriptor = (Job)Descriptor.parse((byte[])data, Job.class);
                    descriptors.put(descriptor.getId(), descriptor);
                }
                catch (KeeperException.NoNodeException e) {
                    log.debug("Ignoring deleted job {}", (Object)jobId);
                }
            }
            return descriptors;
        }
        catch (IOException | KeeperException e) {
            throw new HeliosRuntimeException("getting jobs failed", e);
        }
    }

    @Override
    public JobStatus getJobStatus(JobId jobId) {
        List<String> hosts;
        ZooKeeperClient client = this.provider.get("getJobStatus");
        Job job = this.getJob(client, jobId);
        if (job == null) {
            return null;
        }
        try {
            hosts = this.listJobHosts(client, jobId);
        }
        catch (JobDoesNotExistException e) {
            return null;
        }
        ImmutableMap.Builder deployments = ImmutableMap.builder();
        ImmutableMap.Builder taskStatuses = ImmutableMap.builder();
        for (String host : hosts) {
            Deployment deployment;
            TaskStatus taskStatus = this.getTaskStatus(client, host, jobId);
            if (taskStatus != null) {
                taskStatuses.put((Object)host, (Object)taskStatus);
            }
            if ((deployment = this.getDeployment(host, jobId)) == null) continue;
            deployments.put((Object)host, (Object)deployment);
        }
        ImmutableMap deploymentsMap = deployments.build();
        return JobStatus.newBuilder().setJob(job).setDeployments((Map)deploymentsMap).setTaskStatuses((Map)taskStatuses.build()).build();
    }

    private List<String> listJobHosts(ZooKeeperClient client, JobId jobId) throws JobDoesNotExistException {
        List<String> hosts;
        try {
            hosts = client.getChildren(Paths.configJobHosts(jobId));
        }
        catch (KeeperException.NoNodeException e) {
            throw new JobDoesNotExistException(jobId);
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("failed to list hosts for job: " + jobId, (Throwable)e);
        }
        return hosts;
    }

    @Override
    public Job removeJob(JobId jobId) throws JobDoesNotExistException, JobStillDeployedException {
        try {
            return this.removeJob(jobId, "");
        }
        catch (TokenVerificationException e) {
            throw Throwables.propagate((Throwable)((Object)e));
        }
    }

    @Override
    public Job removeJob(JobId id, String token) throws JobDoesNotExistException, JobStillDeployedException, TokenVerificationException {
        log.info("removing job: id={}", (Object)id);
        ZooKeeperClient client = this.provider.get("removeJob");
        Job job = this.getJob(client, id);
        if (job == null) {
            throw new JobDoesNotExistException(id);
        }
        ZooKeeperMasterModel.verifyToken(token, job);
        try {
            ImmutableList.Builder operations = ImmutableList.builder();
            UUID jobCreationOperationId = this.getJobCreation(client, id);
            if (jobCreationOperationId != null) {
                operations.add((Object)ZooKeeperOperations.delete(Paths.configJobCreation(id, jobCreationOperationId)));
            }
            operations.add((Object[])new ZooKeeperOperation[]{ZooKeeperOperations.delete(Paths.configJobHosts(id)), ZooKeeperOperations.delete(Paths.configJobRefShort(id)), ZooKeeperOperations.delete(Paths.configJob(id)), ZooKeeperOperations.set(Paths.configJobs(), UUID.randomUUID().toString().getBytes())});
            client.transaction((List<ZooKeeperOperation>)operations.build());
        }
        catch (KeeperException.NoNodeException e) {
            throw new JobDoesNotExistException(id);
        }
        catch (KeeperException.NotEmptyException e) {
            throw new JobStillDeployedException(id, this.listJobHosts(client, id));
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("removing job " + id + " failed", (Throwable)e);
        }
        try {
            client.deleteRecursive(Paths.historyJob(id));
        }
        catch (KeeperException.NoNodeException e) {
        }
        catch (KeeperException e) {
            log.warn("error removing job history for job {}", (Object)id, (Object)e);
        }
        return job;
    }

    private UUID getJobCreation(ZooKeeperClient client, JobId id) throws KeeperException {
        String parent = Paths.configHostJobCreationParent(id);
        List<String> children = client.getChildren(parent);
        for (String child : children) {
            if (!Paths.isConfigJobCreation(child)) continue;
            return Paths.configJobCreationId(child);
        }
        return null;
    }

    @Override
    public void deployJob(String host, Deployment job) throws HostNotFoundException, JobAlreadyDeployedException, JobDoesNotExistException, JobPortAllocationConflictException {
        try {
            this.deployJob(host, job, "");
        }
        catch (TokenVerificationException e) {
            throw Throwables.propagate((Throwable)((Object)e));
        }
    }

    @Override
    public void deployJob(String host, Deployment deployment, String token) throws JobDoesNotExistException, JobAlreadyDeployedException, HostNotFoundException, JobPortAllocationConflictException, TokenVerificationException {
        ZooKeeperClient client = this.provider.get("deployJob");
        this.deployJobRetry(client, host, deployment, 0, token);
    }

    private void deployJobRetry(ZooKeeperClient client, String host, Deployment deployment, int count, String token) throws JobDoesNotExistException, JobAlreadyDeployedException, HostNotFoundException, JobPortAllocationConflictException, TokenVerificationException {
        if (count == 3) {
            throw new HeliosRuntimeException("3 failures (possibly concurrent modifications) while deploying. Giving up.");
        }
        log.info("deploying {}: {} (retry={})", new Object[]{deployment, host, count});
        JobId id = deployment.getJobId();
        Job job = this.getJob(id);
        if (job == null) {
            throw new JobDoesNotExistException(id);
        }
        ZooKeeperMasterModel.verifyToken(token, job);
        UUID operationId = UUID.randomUUID();
        String jobPath = Paths.configJob(id);
        try {
            Paths.configHostJob(host, id);
        }
        catch (IllegalArgumentException e) {
            throw new HostNotFoundException("Could not find Helios host '" + host + "'");
        }
        String taskPath = Paths.configHostJob(host, id);
        String taskCreationPath = Paths.configHostJobCreation(host, id, operationId);
        List<Integer> staticPorts = this.staticPorts(job);
        HashMap portNodes = Maps.newHashMap();
        byte[] idJson = id.toJsonBytes();
        for (int port : staticPorts) {
            String path = Paths.configHostPort(host, port);
            portNodes.put(path, idJson);
        }
        Task task = new Task(job, deployment.getGoal(), deployment.getDeployerUser(), deployment.getDeployerMaster(), deployment.getDeploymentGroupName());
        ArrayList operations = Lists.newArrayList((Object[])new ZooKeeperOperation[]{ZooKeeperOperations.check(jobPath), ZooKeeperOperations.create(portNodes), ZooKeeperOperations.create(Paths.configJobHost(id, host))});
        try {
            client.getNode(taskPath);
            throw new JobAlreadyDeployedException(host, id);
        }
        catch (KeeperException.NoNodeException e) {
            operations.add(ZooKeeperOperations.create(taskPath, (Descriptor)task));
            operations.add(ZooKeeperOperations.create(taskCreationPath));
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("reading existing task description failed", (Throwable)e);
        }
        try {
            client.transaction(operations);
            log.info("deployed {}: {} (retry={})", new Object[]{deployment, host, count});
        }
        catch (KeeperException.NoNodeException e) {
            this.assertJobExists(client, id);
            this.assertHostExists(client, host);
            this.deployJobRetry(client, host, deployment, count + 1, token);
        }
        catch (KeeperException.NodeExistsException e) {
            try {
                if (client.exists(taskCreationPath) != null) {
                    return;
                }
            }
            catch (KeeperException ex) {
                throw new HeliosRuntimeException("checking job deployment failed", (Throwable)ex);
            }
            try {
                if (client.stat(taskPath) != null) {
                    throw new JobAlreadyDeployedException(host, id);
                }
            }
            catch (KeeperException ex) {
                throw new HeliosRuntimeException("checking job deployment failed", (Throwable)e);
            }
            for (int port : staticPorts) {
                ZooKeeperMasterModel.checkForPortConflicts(client, host, port, id);
            }
            throw new HeliosRuntimeException("deploying job failed", (Throwable)e);
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("deploying job failed", (Throwable)e);
        }
    }

    private void assertJobExists(ZooKeeperClient client, JobId id) throws JobDoesNotExistException {
        try {
            String path = Paths.configJob(id);
            if (client.stat(path) == null) {
                throw new JobDoesNotExistException(id);
            }
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("checking job existence failed", (Throwable)e);
        }
    }

    private List<Integer> staticPorts(Job job) {
        ArrayList staticPorts = Lists.newArrayList();
        for (PortMapping portMapping : job.getPorts().values()) {
            if (portMapping.getExternalPort() == null) continue;
            staticPorts.add(portMapping.getExternalPort());
        }
        return staticPorts;
    }

    @Override
    public void updateDeployment(String host, Deployment deployment) throws HostNotFoundException, JobNotDeployedException {
        try {
            this.updateDeployment(host, deployment, "");
        }
        catch (TokenVerificationException e) {
            Throwables.propagate((Throwable)((Object)e));
        }
    }

    @Override
    public void updateDeployment(String host, Deployment deployment, String token) throws HostNotFoundException, JobNotDeployedException, TokenVerificationException {
        log.info("updating deployment {}: {}", (Object)deployment, (Object)host);
        ZooKeeperClient client = this.provider.get("updateDeployment");
        JobId jobId = deployment.getJobId();
        Job job = this.getJob(client, jobId);
        Deployment existingDeployment = this.getDeployment(host, jobId);
        if (job == null) {
            throw new JobNotDeployedException(host, jobId);
        }
        ZooKeeperMasterModel.verifyToken(token, job);
        this.assertHostExists(client, host);
        this.assertTaskExists(client, host, deployment.getJobId());
        String path = Paths.configHostJob(host, jobId);
        Task task = new Task(job, deployment.getGoal(), existingDeployment.getDeployerUser(), existingDeployment.getDeployerMaster(), existingDeployment.getDeploymentGroupName());
        try {
            client.setData(path, task.toJsonBytes());
        }
        catch (Exception e) {
            throw new HeliosRuntimeException("updating deployment " + deployment + " on host " + host + " failed", (Throwable)e);
        }
    }

    private void assertHostExists(ZooKeeperClient client, String host) throws HostNotFoundException {
        try {
            client.getData(Paths.configHost(host));
        }
        catch (KeeperException.NoNodeException e) {
            throw new HostNotFoundException(host, e);
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException((Throwable)e);
        }
    }

    private void assertTaskExists(ZooKeeperClient client, String host, JobId jobId) throws JobNotDeployedException {
        try {
            client.getData(Paths.configHostJob(host, jobId));
        }
        catch (KeeperException.NoNodeException e) {
            throw new JobNotDeployedException(host, jobId);
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException((Throwable)e);
        }
    }

    @Override
    public Deployment getDeployment(String host, JobId jobId) {
        String path = Paths.configHostJob(host, jobId);
        ZooKeeperClient client = this.provider.get("getDeployment");
        try {
            byte[] data = client.getData(path);
            Task task = (Task)Descriptor.parse((byte[])data, Task.class);
            return Deployment.of((JobId)jobId, (Goal)task.getGoal(), (String)task.getDeployerUser(), (String)task.getDeployerMaster(), (String)task.getDeploymentGroupName());
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (IOException | KeeperException e) {
            throw new HeliosRuntimeException("getting deployment failed", e);
        }
    }

    @Override
    public HostStatus getHostStatus(String host) {
        Stat stat;
        ZooKeeperClient client = this.provider.get("getHostStatus");
        try {
            stat = client.exists(Paths.configHostId(host));
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("Failed to check host status", (Throwable)e);
        }
        if (stat == null) {
            log.warn("Missing configuration for host {}", (Object)host);
            return null;
        }
        boolean up = this.checkHostUp(client, host);
        HostInfo hostInfo = this.getHostInfo(client, host);
        AgentInfo agentInfo = this.getAgentInfo(client, host);
        Map<JobId, Deployment> tasks = this.getTasks(client, host);
        Map<JobId, TaskStatus> statuses = this.getTaskStatuses(client, host);
        Map<String, String> environment = this.getEnvironment(client, host);
        Map<String, String> labels = this.getLabels(client, host);
        return HostStatus.newBuilder().setJobs(tasks).setStatuses((Map)Optional.fromNullable(statuses).or(EMPTY_STATUSES)).setHostInfo(hostInfo).setAgentInfo(agentInfo).setStatus(up ? HostStatus.Status.UP : HostStatus.Status.DOWN).setEnvironment(environment).setLabels(labels).build();
    }

    private <T> T tryGetEntity(ZooKeeperClient client, String path, TypeReference<T> type, String name) {
        try {
            byte[] data = client.getData(path);
            return (T)Json.read((byte[])data, type);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (IOException | KeeperException e) {
            throw new HeliosRuntimeException("reading " + name + " info failed", e);
        }
    }

    private Map<String, String> getEnvironment(ZooKeeperClient client, String host) {
        return this.tryGetEntity(client, Paths.statusHostEnvVars(host), STRING_MAP_TYPE, "environment");
    }

    private Map<String, String> getLabels(ZooKeeperClient client, String host) {
        return this.tryGetEntity(client, Paths.statusHostLabels(host), STRING_MAP_TYPE, "labels");
    }

    private AgentInfo getAgentInfo(ZooKeeperClient client, String host) {
        return this.tryGetEntity(client, Paths.statusHostAgentInfo(host), AGENT_INFO_TYPE, "agent info");
    }

    private HostInfo getHostInfo(ZooKeeperClient client, String host) {
        return this.tryGetEntity(client, Paths.statusHostInfo(host), HOST_INFO_TYPE, "host info");
    }

    private boolean checkHostUp(ZooKeeperClient client, String host) {
        try {
            Stat stat = client.exists(Paths.statusHostUp(host));
            return stat != null;
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("getting host " + host + " up status failed", (Throwable)e);
        }
    }

    private Map<JobId, TaskStatus> getTaskStatuses(ZooKeeperClient client, String host) {
        HashMap statuses = Maps.newHashMap();
        List<JobId> jobIds = this.listHostJobs(client, host);
        for (JobId jobId : jobIds) {
            TaskStatus status;
            try {
                status = this.getTaskStatus(client, host, jobId);
            }
            catch (HeliosRuntimeException e) {
                status = null;
            }
            if (status != null) {
                statuses.put(jobId, status);
                continue;
            }
            log.debug("Task {} status missing for host {}", (Object)jobId, (Object)host);
        }
        return statuses;
    }

    private List<JobId> listHostJobs(ZooKeeperClient client, String host) {
        List<String> jobIdStrings;
        String folder = Paths.statusHostJobs(host);
        try {
            jobIdStrings = client.getChildren(folder);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("List tasks for host failed: " + host, (Throwable)e);
        }
        ImmutableList.Builder jobIds = ImmutableList.builder();
        for (String jobIdString : jobIdStrings) {
            jobIds.add((Object)JobId.fromString((String)jobIdString));
        }
        return jobIds.build();
    }

    @Nullable
    private TaskStatus getTaskStatus(ZooKeeperClient client, String host, JobId jobId) {
        String containerPath = Paths.statusHostJob(host, jobId);
        try {
            byte[] data = client.getData(containerPath);
            return (TaskStatus)Descriptor.parse((byte[])data, TaskStatus.class);
        }
        catch (KeeperException.NoNodeException ignored) {
            return null;
        }
        catch (IOException | KeeperException e) {
            throw new HeliosRuntimeException("Getting task " + jobId + " status for host " + host + " failed", e);
        }
    }

    private Map<JobId, Deployment> getTasks(ZooKeeperClient client, String host) {
        HashMap jobs = Maps.newHashMap();
        try {
            List<String> jobIds;
            String folder = Paths.configHostJobs(host);
            try {
                jobIds = client.getChildren(folder);
            }
            catch (KeeperException.NoNodeException e) {
                log.warn("Unable to get deployment config for {}", (Object)host, (Object)e);
                return ImmutableMap.of();
            }
            for (String jobIdString : jobIds) {
                JobId jobId = JobId.fromString((String)jobIdString);
                String containerPath = Paths.configHostJob(host, jobId);
                try {
                    byte[] data = client.getData(containerPath);
                    Task task = (Task)Descriptor.parse((byte[])data, Task.class);
                    jobs.put(jobId, Deployment.of((JobId)jobId, (Goal)task.getGoal(), (String)task.getDeployerUser(), (String)task.getDeployerMaster(), (String)task.getDeploymentGroupName()));
                }
                catch (KeeperException.NoNodeException ignored) {
                    log.debug("deployment config node disappeared: {}", (Object)jobIdString);
                }
            }
        }
        catch (IOException | KeeperException e) {
            throw new HeliosRuntimeException("getting deployment config failed", e);
        }
        return jobs;
    }

    @Override
    public Deployment undeployJob(String host, JobId jobId) throws HostNotFoundException, JobNotDeployedException {
        try {
            return this.undeployJob(host, jobId, "");
        }
        catch (TokenVerificationException e) {
            throw Throwables.propagate((Throwable)((Object)e));
        }
    }

    @Override
    public Deployment undeployJob(String host, JobId jobId, String token) throws HostNotFoundException, JobNotDeployedException, TokenVerificationException {
        log.info("undeploying {}: {}", (Object)jobId, (Object)host);
        ZooKeeperClient client = this.provider.get("undeployJob");
        this.assertHostExists(client, host);
        Deployment deployment = this.getDeployment(host, jobId);
        if (deployment == null) {
            throw new JobNotDeployedException(host, jobId);
        }
        Job job = this.getJob(client, jobId);
        ZooKeeperMasterModel.verifyToken(token, job);
        String configHostJobPath = Paths.configHostJob(host, jobId);
        try {
            ArrayList nodes = Lists.newArrayList((Iterable)Lists.reverse(client.listRecursive(configHostJobPath)));
            nodes.add(Paths.configJobHost(jobId, host));
            List<Integer> staticPorts = this.staticPorts(job);
            for (int port : staticPorts) {
                nodes.add(Paths.configHostPort(host, port));
            }
            client.transaction(ZooKeeperOperations.delete(nodes));
        }
        catch (KeeperException.NoNodeException e) {
            throw new JobNotDeployedException(host, jobId);
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("Removing deployment failed", (Throwable)e);
        }
        return deployment;
    }

    private List<ZooKeeperOperation> getUndeployOperations(ZooKeeperClient client, String host, JobId jobId, String token) throws HostNotFoundException, JobNotDeployedException, TokenVerificationException {
        this.assertHostExists(client, host);
        Deployment deployment = this.getDeployment(host, jobId);
        if (deployment == null) {
            throw new JobNotDeployedException(host, jobId);
        }
        Job job = this.getJob(client, jobId);
        ZooKeeperMasterModel.verifyToken(token, job);
        String configHostJobPath = Paths.configHostJob(host, jobId);
        try {
            ArrayList nodes = Lists.newArrayList((Iterable)Lists.reverse(client.listRecursive(configHostJobPath)));
            nodes.add(Paths.configJobHost(jobId, host));
            List<Integer> staticPorts = this.staticPorts(job);
            for (int port : staticPorts) {
                nodes.add(Paths.configHostPort(host, port));
            }
            return ImmutableList.of((Object)ZooKeeperOperations.delete(nodes));
        }
        catch (KeeperException.NoNodeException e) {
            throw new JobNotDeployedException(host, jobId);
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("calculating undeploy operations failed", (Throwable)e);
        }
    }

    private List<ZooKeeperOperation> getDeployOperations(ZooKeeperClient client, String host, Deployment deployment, String token) throws JobDoesNotExistException, JobAlreadyDeployedException, TokenVerificationException, HostNotFoundException, JobPortAllocationConflictException {
        this.assertHostExists(client, host);
        JobId id = deployment.getJobId();
        Job job = this.getJob(id);
        if (job == null) {
            throw new JobDoesNotExistException(id);
        }
        ZooKeeperMasterModel.verifyToken(token, job);
        UUID operationId = UUID.randomUUID();
        String jobPath = Paths.configJob(id);
        String taskPath = Paths.configHostJob(host, id);
        String taskCreationPath = Paths.configHostJobCreation(host, id, operationId);
        List<Integer> staticPorts = this.staticPorts(job);
        HashMap portNodes = Maps.newHashMap();
        byte[] idJson = id.toJsonBytes();
        for (int port : staticPorts) {
            String path = Paths.configHostPort(host, port);
            portNodes.put(path, idJson);
        }
        Task task = new Task(job, deployment.getGoal(), deployment.getDeployerUser(), deployment.getDeployerMaster(), deployment.getDeploymentGroupName());
        ArrayList operations = Lists.newArrayList((Object[])new ZooKeeperOperation[]{ZooKeeperOperations.check(jobPath), ZooKeeperOperations.create(portNodes), ZooKeeperOperations.create(Paths.configJobHost(id, host))});
        try {
            client.getNode(taskPath);
            throw new JobAlreadyDeployedException(host, id);
        }
        catch (KeeperException.NoNodeException e) {
            for (int port : staticPorts) {
                ZooKeeperMasterModel.checkForPortConflicts(client, host, port, id);
            }
            operations.add(ZooKeeperOperations.create(taskPath, (Descriptor)task));
            operations.add(ZooKeeperOperations.create(taskCreationPath));
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("reading existing task description failed", (Throwable)e);
        }
        return ImmutableList.copyOf((Collection)operations);
    }

    private static void verifyToken(String token, Job job) throws TokenVerificationException {
        Preconditions.checkNotNull((Object)token, (Object)"token");
        if (!token.equals(job.getToken())) {
            throw new TokenVerificationException(job.getId());
        }
    }

    private static void checkForPortConflicts(ZooKeeperClient client, String host, int port, JobId jobId) throws JobPortAllocationConflictException {
        try {
            String path = Paths.configHostPort(host, port);
            if (client.stat(path) == null) {
                return;
            }
            byte[] b = client.getData(path);
            JobId existingJobId = (JobId)Descriptor.parse((byte[])b, JobId.class);
            throw new JobPortAllocationConflictException(jobId, existingJobId, host, port);
        }
        catch (IOException | KeeperException ex) {
            throw new HeliosRuntimeException("checking port allocations failed", ex);
        }
    }

    private List<TaskStatus.State> getPreviousJobStates(JobId jobId, String host, int maxStates) {
        List previousStates;
        try {
            List<TaskStatusEvent> jobHistory = this.getJobHistory(jobId, host);
            List<TaskStatusEvent> cappedJobHistory = jobHistory.subList(0, Math.min(maxStates, jobHistory.size()));
            Function<TaskStatusEvent, TaskStatus.State> statusesToStrings = new Function<TaskStatusEvent, TaskStatus.State>(){

                public TaskStatus.State apply(@Nullable TaskStatusEvent input) {
                    if (input != null) {
                        return input.getStatus().getState();
                    }
                    return null;
                }
            };
            previousStates = Lists.transform(cappedJobHistory, (Function)statusesToStrings);
        }
        catch (JobDoesNotExistException ignored) {
            previousStates = Collections.emptyList();
        }
        return previousStates;
    }
}

