/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master.http;

import com.spotify.helios.common.PomVersion;
import com.spotify.helios.common.VersionCompatibility;
import com.spotify.helios.servicescommon.statistics.MasterMetrics;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionResponseFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(VersionResponseFilter.class);
    private static final PomVersion SERVER_VERSION = PomVersion.parse((String)"0.9.54");
    private final MasterMetrics metrics;

    public VersionResponseFilter(MasterMetrics metrics) {
        this.metrics = metrics;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        PomVersion clientVersion;
        if (!(request instanceof HttpServletRequest)) {
            log.debug("request is not HTTP");
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpReq = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.addHeader("Helios-Server-Version", SERVER_VERSION.toString());
        String header = httpReq.getHeader("Helios-Version");
        if (header == null) {
            log.debug("No header Helios-Version");
            httpResponse.addHeader("Helios-Version-Status", VersionCompatibility.Status.MISSING.toString());
            chain.doFilter(request, response);
            return;
        }
        try {
            clientVersion = PomVersion.parse((String)header);
        }
        catch (RuntimeException e) {
            log.debug("failure to parse version header " + header);
            httpResponse.addHeader("Helios-Version-Status", VersionCompatibility.Status.INVALID.toString());
            httpResponse.sendError(400, "Helios client version format is bogus - expect n.n.n");
            return;
        }
        this.metrics.clientVersion(clientVersion.toString());
        VersionCompatibility.Status status = VersionCompatibility.getStatus((PomVersion)SERVER_VERSION, (PomVersion)clientVersion);
        httpResponse.addHeader("Helios-Version-Status", status.toString());
        if (status == VersionCompatibility.Status.INCOMPATIBLE) {
            log.debug("version " + clientVersion + " is incompatible");
            httpResponse.sendError(426, "Your client version is incompatible with the server version 0.9.54");
        } else {
            log.debug("version " + clientVersion + " state " + status);
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void destroy() {
    }
}

