/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master.metrics;

import com.google.common.collect.Maps;
import com.spotify.helios.servicescommon.statistics.MasterMetrics;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.spi.dispatch.RequestDispatcher;
import java.util.concurrent.ConcurrentMap;
import javax.ws.rs.WebApplicationException;

public class ReportingResourceMethodDispatcher
implements RequestDispatcher {
    private final RequestDispatcher dispatcher;
    private final MasterMetrics metrics;
    private final ConcurrentMap<Object, String> keys = Maps.newConcurrentMap();

    public ReportingResourceMethodDispatcher(RequestDispatcher dispatcher, MasterMetrics metrics) {
        this.dispatcher = dispatcher;
        this.metrics = metrics;
    }

    public void dispatch(Object resource, HttpContext context) {
        AbstractResourceMethod resourceMethod = context.getUriInfo().getMatchedMethod();
        String key = this.getKey(resourceMethod);
        try {
            this.dispatcher.dispatch(resource, context);
            this.metrics.success(key);
        }
        catch (WebApplicationException e) {
            int status = e.getResponse().getStatus();
            if (status == 404) {
                this.metrics.success(key);
            } else if (status > 400 && status < 500) {
                this.metrics.badRequest(key);
            } else {
                this.metrics.failure(key);
            }
            throw e;
        }
        catch (Exception e) {
            this.metrics.failure(key);
            throw e;
        }
    }

    private String getKey(AbstractResourceMethod resourceMethod) {
        String key = (String)this.keys.get(resourceMethod);
        if (key == null) {
            String name = resourceMethod.getMethod().getDeclaringClass().getSimpleName() + "#" + resourceMethod.getMethod().getName();
            this.keys.put(resourceMethod, name);
            return name;
        }
        return key;
    }
}

