/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master.reaper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.spotify.helios.common.Clock;
import com.spotify.helios.common.SystemClock;
import com.spotify.helios.common.descriptors.AgentInfo;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.master.MasterModel;
import com.spotify.helios.master.reaper.RateLimitedService;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadAgentReaper
extends RateLimitedService<String> {
    private static final double PERMITS_PER_SECOND = 0.2;
    private static final Clock SYSTEM_CLOCK = new SystemClock();
    private static final int DELAY = 30;
    private static final TimeUnit TIME_UNIT = TimeUnit.MINUTES;
    private static final Logger log = LoggerFactory.getLogger(DeadAgentReaper.class);
    private final MasterModel masterModel;
    private final long timeoutMillis;
    private final Clock clock;

    public DeadAgentReaper(MasterModel masterModel, long timeoutHours) {
        this(masterModel, timeoutHours, SYSTEM_CLOCK, 0.2, new Random().nextInt(30));
    }

    @VisibleForTesting
    DeadAgentReaper(MasterModel masterModel, long timeoutHours, Clock clock, double permitsPerSecond, int initialDelay) {
        super(permitsPerSecond, initialDelay, 30L, TIME_UNIT);
        this.masterModel = masterModel;
        Preconditions.checkArgument((timeoutHours > 0L ? 1 : 0) != 0);
        this.timeoutMillis = TimeUnit.HOURS.toMillis(timeoutHours);
        this.clock = clock;
    }

    @Override
    Iterable<String> collectItems() {
        return this.masterModel.listHosts();
    }

    @Override
    void processItem(String agent) {
        try {
            HostStatus hostStatus = this.masterModel.getHostStatus(agent);
            if (hostStatus == null || hostStatus.getStatus() != HostStatus.Status.DOWN) {
                return;
            }
            AgentInfo agentInfo = hostStatus.getAgentInfo();
            if (agentInfo == null) {
                return;
            }
            long downSince = agentInfo.getStartTime() + agentInfo.getUptime();
            long downDurationMillis = this.clock.now().getMillis() - downSince;
            if (downDurationMillis >= this.timeoutMillis) {
                try {
                    log.info("Reaping dead agent '{}' (DOWN for {} hours)", (Object)agent, (Object)DurationFormatUtils.formatDurationHMS((long)downDurationMillis));
                    this.masterModel.deregisterHost(agent);
                }
                catch (Exception e) {
                    log.warn("Failed to reap agent '{}'", (Object)agent, (Object)e);
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to determine if agent '{}' should be reaped", (Object)agent, (Object)e);
        }
    }
}

