/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master.reaper;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.spotify.helios.agent.InterruptingScheduledService;
import com.spotify.helios.common.Clock;
import com.spotify.helios.common.SystemClock;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.master.HostNotFoundException;
import com.spotify.helios.master.JobDoesNotExistException;
import com.spotify.helios.master.JobNotDeployedException;
import com.spotify.helios.master.JobStillDeployedException;
import com.spotify.helios.master.MasterModel;
import com.spotify.helios.master.TokenVerificationException;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiredJobReaper
extends InterruptingScheduledService {
    private static final Logger log = LoggerFactory.getLogger(ExpiredJobReaper.class);
    private static final int DEFAULT_INTERVAL = 30;
    private static final TimeUnit DEFAUL_TIMEUNIT = TimeUnit.SECONDS;
    private final MasterModel masterModel;
    private final int interval;
    private final TimeUnit timeUnit;
    private final Clock clock;

    private ExpiredJobReaper(Builder builder) {
        this.masterModel = builder.masterModel;
        this.interval = builder.interval;
        this.timeUnit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)builder.timeUnit)));
        this.clock = (Clock)Preconditions.checkNotNull((Object)builder.clock);
    }

    @Override
    public void runOneIteration() {
        for (Map.Entry<JobId, Job> entry : this.masterModel.getJobs().entrySet()) {
            JobId jobId = entry.getKey();
            Job job = entry.getValue();
            if (job.getExpires() == null || job.getExpires().getTime() > this.clock.now().getMillis()) continue;
            JobStatus status = this.masterModel.getJobStatus(jobId);
            ImmutableList hosts = ImmutableList.copyOf(status.getDeployments().keySet());
            for (String host : hosts) {
                try {
                    this.masterModel.undeployJob(host, jobId, job.getToken());
                }
                catch (HostNotFoundException e) {
                    log.error("couldn't undeploy job {} from host {} when it hit deadline", new Object[]{jobId, host, e});
                }
                catch (JobNotDeployedException e) {
                    log.debug("job {} was already undeployed when it hit deadline", (Object)jobId, (Object)e);
                }
                catch (TokenVerificationException e) {
                    log.error("couldn't undeploy job {} from host {} because token verification failed", new Object[]{jobId, host, e});
                }
            }
            try {
                this.masterModel.removeJob(jobId, job.getToken());
            }
            catch (JobDoesNotExistException e) {
                log.debug("job {} was already removed when it hit deadline", (Object)jobId, (Object)e);
            }
            catch (JobStillDeployedException e) {
                log.debug("job {} still deployed on some host(s) after expiry reap", (Object)jobId, (Object)e);
            }
            catch (TokenVerificationException e) {
                log.error("couldn't remove job {} because token verification failed", (Object)jobId, (Object)e);
            }
        }
    }

    @Override
    protected ScheduledFuture<?> schedule(Runnable runnable, ScheduledExecutorService executorService) {
        return executorService.scheduleWithFixedDelay(runnable, new Random().nextInt(this.interval), this.interval, this.timeUnit);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static /* synthetic */ TimeUnit access$500() {
        return DEFAUL_TIMEUNIT;
    }

    public static class Builder {
        private MasterModel masterModel;
        private int interval = 30;
        private TimeUnit timeUnit = ExpiredJobReaper.access$500();
        private Clock clock = new SystemClock();

        private Builder() {
        }

        public Builder setClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder setMasterModel(MasterModel masterModel) {
            this.masterModel = masterModel;
            return this;
        }

        public Builder setInterval(int interval) {
            this.interval = interval;
            return this;
        }

        public Builder setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public ExpiredJobReaper build() {
            return new ExpiredJobReaper(this);
        }
    }
}

