/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master.reaper;

import com.google.common.annotations.VisibleForTesting;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.master.MasterModel;
import com.spotify.helios.master.reaper.RateLimitedService;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobHistoryReaper
extends RateLimitedService<String> {
    private static final double PERMITS_PER_SECOND = 0.2;
    private static final int DELAY = 1440;
    private static final TimeUnit TIME_UNIT = TimeUnit.MINUTES;
    private static final Logger log = LoggerFactory.getLogger(JobHistoryReaper.class);
    private final MasterModel masterModel;
    private final ZooKeeperClient client;

    public JobHistoryReaper(MasterModel masterModel, ZooKeeperClient client) {
        this(masterModel, client, 0.2, new Random().nextInt(1440));
    }

    @VisibleForTesting
    JobHistoryReaper(MasterModel masterModel, ZooKeeperClient client, double permitsPerSecond, int initialDelay) {
        super(permitsPerSecond, initialDelay, 1440L, TIME_UNIT);
        this.masterModel = masterModel;
        this.client = client;
    }

    @Override
    Iterable<String> collectItems() {
        String path = Paths.historyJobs();
        List<String> jobIds = Collections.emptyList();
        try {
            jobIds = this.client.getChildren(path);
        }
        catch (KeeperException e) {
            log.warn("Failed to get children of znode {}", (Object)path, (Object)e);
        }
        return jobIds;
    }

    @Override
    void processItem(String jobId) {
        log.info("Deciding whether to reap job history for job {}", (Object)jobId);
        JobId id = JobId.fromString((String)jobId);
        Job job = this.masterModel.getJob(id);
        if (job == null) {
            try {
                this.client.deleteRecursive(Paths.historyJob(id));
                log.info("Reaped job history for job {}", (Object)jobId);
            }
            catch (KeeperException.NoNodeException noNodeException) {
            }
            catch (KeeperException e) {
                log.warn("error reaping job history for job {}", (Object)jobId, (Object)e);
            }
        }
    }
}

