/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master.reaper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.spotify.helios.common.Clock;
import com.spotify.helios.common.SystemClock;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.common.descriptors.TaskStatusEvent;
import com.spotify.helios.master.MasterModel;
import com.spotify.helios.master.reaper.RateLimitedService;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OldJobReaper
extends RateLimitedService<Job> {
    private static final double PERMITS_PER_SECOND = 0.2;
    private static final Clock SYSTEM_CLOCK = new SystemClock();
    private static final int DELAY = 1440;
    private static final TimeUnit TIME_UNIT = TimeUnit.MINUTES;
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"YYYY-MM-dd HH:mm:ss");
    private static final Logger log = LoggerFactory.getLogger(OldJobReaper.class);
    private final MasterModel masterModel;
    private final long retentionDays;
    private final long retentionMillis;
    private final Clock clock;

    public OldJobReaper(MasterModel masterModel, long retentionDays) {
        this(masterModel, retentionDays, SYSTEM_CLOCK, 0.2, new Random().nextInt(1440));
    }

    @VisibleForTesting
    OldJobReaper(MasterModel masterModel, long retentionDays, Clock clock, double permitsPerSecond, int initialDelay) {
        super(permitsPerSecond, initialDelay, 1440L, TIME_UNIT);
        this.masterModel = masterModel;
        Preconditions.checkArgument((retentionDays > 0L ? 1 : 0) != 0);
        this.retentionDays = retentionDays;
        this.retentionMillis = TimeUnit.DAYS.toMillis(retentionDays);
        this.clock = clock;
    }

    @Override
    Iterable<Job> collectItems() {
        return this.masterModel.getJobs().values();
    }

    @Override
    void processItem(Job job) {
        log.info("Deciding whether to reap job {}", (Object)job.getId());
        JobId jobId = job.getId();
        try {
            boolean reap;
            JobStatus jobStatus = this.masterModel.getJobStatus(jobId);
            Map deployments = jobStatus.getDeployments();
            List<TaskStatusEvent> events = this.masterModel.getJobHistory(jobId);
            if (deployments.isEmpty()) {
                if (events.isEmpty()) {
                    Long created = job.getCreated();
                    if (created == null) {
                        log.info("Marked job '{}' for reaping (not deployed, no history, no creation date)", (Object)jobId);
                        reap = true;
                    } else if (this.clock.now().getMillis() - created > this.retentionMillis) {
                        log.info("Marked job '{}' for reaping (not deployed, no history, creation date of {} before retention time of {} days)", new Object[]{jobId, DATE_FORMATTER.print(created.longValue()), this.retentionDays});
                        reap = true;
                    } else {
                        log.info("NOT reaping job '{}' (not deployed, no history, creation date of {} after retention time of {} days)", new Object[]{jobId, DATE_FORMATTER.print(created.longValue()), this.retentionDays});
                        reap = false;
                    }
                } else {
                    TaskStatusEvent event = events.get(events.size() - 1);
                    String eventDate = DATE_FORMATTER.print(event.getTimestamp());
                    long unusedDurationMillis = this.clock.now().getMillis() - event.getTimestamp();
                    if (unusedDurationMillis > this.retentionMillis) {
                        log.info("Marked job '{}' for reaping (not deployed, has history whose last event on {} was before the retention time of {} days)", new Object[]{jobId, eventDate, this.retentionDays});
                        reap = true;
                    } else {
                        log.info("NOT reaping job '{}' (not deployed, has history whose last event on {} was after the retention time of {} days)", new Object[]{jobId, eventDate, this.retentionDays});
                        reap = false;
                    }
                }
            } else {
                log.info("NOT reaping job '{}' (it is deployed)", (Object)jobId);
                reap = false;
            }
            if (reap) {
                try {
                    this.masterModel.removeJob(jobId, job.getToken());
                }
                catch (Exception e) {
                    log.warn("Failed to reap old job '{}'", (Object)jobId, (Object)e);
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to determine if job '{}' should be reaped", (Object)jobId, (Object)e);
        }
    }
}

