/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master.reaper;

import com.google.common.util.concurrent.RateLimiter;
import com.spotify.helios.agent.InterruptingScheduledService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

abstract class RateLimitedService<T>
extends InterruptingScheduledService {
    private final long initialDelay;
    private final long delay;
    private final TimeUnit timeUnit;
    private final RateLimiter rateLimiter;

    RateLimitedService(double permitsPerSecond, long initialDelay, long delay, TimeUnit timeUnit) {
        this.rateLimiter = RateLimiter.create((double)permitsPerSecond);
        this.initialDelay = initialDelay;
        this.delay = delay;
        this.timeUnit = timeUnit;
    }

    abstract Iterable<T> collectItems();

    abstract void processItem(T var1);

    @Override
    protected void runOneIteration() {
        for (T item : this.collectItems()) {
            this.rateLimiter.acquire();
            this.processItem(item);
        }
    }

    @Override
    protected ScheduledFuture<?> schedule(Runnable runnable, ScheduledExecutorService executorService) {
        return executorService.scheduleWithFixedDelay(runnable, this.initialDelay, this.delay, this.timeUnit);
    }
}

