/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master.resources;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Lists;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.DeploymentGroup;
import com.spotify.helios.common.descriptors.DeploymentGroupStatus;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.protocol.CreateDeploymentGroupResponse;
import com.spotify.helios.common.protocol.DeploymentGroupStatusResponse;
import com.spotify.helios.common.protocol.RemoveDeploymentGroupResponse;
import com.spotify.helios.common.protocol.RollingUpdateRequest;
import com.spotify.helios.common.protocol.RollingUpdateResponse;
import com.spotify.helios.master.DeploymentGroupDoesNotExistException;
import com.spotify.helios.master.DeploymentGroupExistsException;
import com.spotify.helios.master.JobDoesNotExistException;
import com.spotify.helios.master.MasterModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/deployment-group")
public class DeploymentGroupResource {
    private final MasterModel model;
    private static final CreateDeploymentGroupResponse CREATED_RESPONSE = new CreateDeploymentGroupResponse(CreateDeploymentGroupResponse.Status.CREATED);
    private static final CreateDeploymentGroupResponse NOT_MODIFIED_RESPONSE = new CreateDeploymentGroupResponse(CreateDeploymentGroupResponse.Status.NOT_MODIFIED);
    private static final CreateDeploymentGroupResponse DEPLOYMENT_GROUP_ALREADY_EXISTS_RESPONSE = new CreateDeploymentGroupResponse(CreateDeploymentGroupResponse.Status.CONFLICT);

    public DeploymentGroupResource(MasterModel model) {
        this.model = model;
    }

    @POST
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public Response createDeploymentGroup(@Valid DeploymentGroup deploymentGroup) {
        try {
            this.model.addDeploymentGroup(deploymentGroup);
            return Response.ok((Object)CREATED_RESPONSE).build();
        }
        catch (DeploymentGroupExistsException ignored) {
            DeploymentGroup existing;
            try {
                existing = this.model.getDeploymentGroup(deploymentGroup.getName());
            }
            catch (DeploymentGroupDoesNotExistException e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
            if (!Objects.equals(existing.getHostSelectors(), deploymentGroup.getHostSelectors())) {
                return Response.ok((Object)DEPLOYMENT_GROUP_ALREADY_EXISTS_RESPONSE).build();
            }
            return Response.ok((Object)NOT_MODIFIED_RESPONSE).build();
        }
    }

    @GET
    @Path(value="/{name}")
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public Response getDeploymentGroup(@PathParam(value="name") String name) {
        try {
            return Response.ok((Object)this.model.getDeploymentGroup(name)).build();
        }
        catch (DeploymentGroupDoesNotExistException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @DELETE
    @Path(value="/{name}")
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public Response removeDeploymentGroup(@PathParam(value="name") @Valid String name) {
        try {
            this.model.removeDeploymentGroup(name);
            return Response.ok((Object)new RemoveDeploymentGroupResponse(RemoveDeploymentGroupResponse.Status.REMOVED)).build();
        }
        catch (DeploymentGroupDoesNotExistException e) {
            return Response.ok((Object)new RemoveDeploymentGroupResponse(RemoveDeploymentGroupResponse.Status.DEPLOYMENT_GROUP_NOT_FOUND)).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public List<String> getDeploymentGroup() {
        ArrayList deploymentGroups = Lists.newArrayList(this.model.getDeploymentGroups().keySet());
        Collections.sort(deploymentGroups);
        return deploymentGroups;
    }

    @POST
    @Path(value="/{name}/rolling-update")
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public Response rollingUpdate(@PathParam(value="name") @Valid String name, @Valid RollingUpdateRequest args) {
        try {
            DeploymentGroup deploymentGroup = this.model.getDeploymentGroup(name);
            this.model.rollingUpdate(deploymentGroup, args.getJob(), args.getRolloutOptions());
            return Response.ok((Object)new RollingUpdateResponse(RollingUpdateResponse.Status.OK)).build();
        }
        catch (DeploymentGroupDoesNotExistException e) {
            return Response.ok((Object)new RollingUpdateResponse(RollingUpdateResponse.Status.DEPLOYMENT_GROUP_NOT_FOUND)).build();
        }
        catch (JobDoesNotExistException e) {
            return Response.ok((Object)new RollingUpdateResponse(RollingUpdateResponse.Status.JOB_NOT_FOUND)).build();
        }
    }

    @POST
    @Path(value="/{name}/stop")
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public Response stopDeploymentGroup(@PathParam(value="name") @Valid String name) {
        try {
            this.model.stopDeploymentGroup(name);
            return Response.noContent().build();
        }
        catch (DeploymentGroupDoesNotExistException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @GET
    @Path(value="/{name}/status")
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public Response getDeploymentGroupStatus(@PathParam(value="name") @Valid String name) {
        try {
            DeploymentGroup deploymentGroup = this.model.getDeploymentGroup(name);
            DeploymentGroupStatus deploymentGroupStatus = this.model.getDeploymentGroupStatus(name);
            List<String> hosts = this.model.getDeploymentGroupHosts(name);
            ArrayList result = Lists.newArrayList();
            for (String host : hosts) {
                HostStatus hostStatus = this.model.getHostStatus(host);
                JobId deployedJobId = null;
                TaskStatus.State state = null;
                if (hostStatus == null || !hostStatus.getStatus().equals((Object)HostStatus.Status.UP)) continue;
                for (Map.Entry entry : hostStatus.getJobs().entrySet()) {
                    if (!name.equals(((Deployment)entry.getValue()).getDeploymentGroupName())) continue;
                    deployedJobId = (JobId)entry.getKey();
                    TaskStatus taskStatus = (TaskStatus)hostStatus.getStatuses().get(deployedJobId);
                    if (taskStatus == null) break;
                    state = taskStatus.getState();
                    break;
                }
                result.add(new DeploymentGroupStatusResponse.HostStatus(host, deployedJobId, state));
            }
            DeploymentGroupStatusResponse.Status status = deploymentGroupStatus == null ? DeploymentGroupStatusResponse.Status.IDLE : (deploymentGroupStatus.getState() == DeploymentGroupStatus.State.FAILED ? DeploymentGroupStatusResponse.Status.FAILED : (deploymentGroupStatus.getState() == DeploymentGroupStatus.State.ROLLING_OUT ? DeploymentGroupStatusResponse.Status.ROLLING_OUT : DeploymentGroupStatusResponse.Status.ACTIVE));
            String error = deploymentGroupStatus == null ? "" : deploymentGroupStatus.getError();
            return Response.ok((Object)new DeploymentGroupStatusResponse(deploymentGroup, status, error, (List)result, deploymentGroupStatus)).build();
        }
        catch (DeploymentGroupDoesNotExistException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }
}

