/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master.resources;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableList;
import com.spotify.helios.common.HeliosException;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatusEvent;
import com.spotify.helios.common.protocol.TaskStatusEvents;
import com.spotify.helios.master.JobDoesNotExistException;
import com.spotify.helios.master.MasterModel;
import com.spotify.helios.master.http.Responses;
import com.spotify.helios.servicescommon.statistics.MasterMetrics;
import java.util.List;
import javax.validation.Valid;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/history")
public class HistoryResource {
    private final MasterModel model;
    private final MasterMetrics metrics;

    public HistoryResource(MasterModel model, MasterMetrics metrics) {
        this.model = model;
        this.metrics = metrics;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="jobs/{id}")
    @Timed
    @ExceptionMetered
    public TaskStatusEvents jobHistory(@PathParam(value="id") @Valid JobId jobId) throws HeliosException {
        if (!jobId.isFullyQualified()) {
            throw Responses.badRequest("Invalid id");
        }
        try {
            List<TaskStatusEvent> events = this.model.getJobHistory(jobId);
            this.metrics.jobsHistoryEventSize(events.size());
            TaskStatusEvents result = new TaskStatusEvents(events, TaskStatusEvents.Status.OK);
            return result;
        }
        catch (JobDoesNotExistException e) {
            return new TaskStatusEvents((List)ImmutableList.of(), TaskStatusEvents.Status.JOB_ID_NOT_FOUND);
        }
    }
}

