/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master.resources;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.HostSelector;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.protocol.HostDeregisterResponse;
import com.spotify.helios.common.protocol.HostRegisterResponse;
import com.spotify.helios.common.protocol.JobDeployResponse;
import com.spotify.helios.common.protocol.JobUndeployResponse;
import com.spotify.helios.common.protocol.SetGoalResponse;
import com.spotify.helios.master.HostMatcher;
import com.spotify.helios.master.HostNotFoundException;
import com.spotify.helios.master.HostStillInUseException;
import com.spotify.helios.master.JobAlreadyDeployedException;
import com.spotify.helios.master.JobDoesNotExistException;
import com.spotify.helios.master.JobNotDeployedException;
import com.spotify.helios.master.JobPortAllocationConflictException;
import com.spotify.helios.master.MasterModel;
import com.spotify.helios.master.TokenVerificationException;
import com.spotify.helios.master.http.PATCH;
import com.spotify.helios.master.http.Responses;
import com.spotify.helios.master.resources.RequestUser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/hosts")
public class HostsResource {
    private static final Logger log = LoggerFactory.getLogger(HostsResource.class);
    private final MasterModel model;

    public HostsResource(MasterModel model) {
        this.model = model;
    }

    @GET
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public List<String> list(@QueryParam(value="namePattern") String namePattern, @QueryParam(value="selector") List<String> hostSelectors) {
        List<String> hosts = this.model.listHosts();
        if (namePattern != null) {
            Predicate<String> matchesPattern = Pattern.compile(namePattern).asPredicate();
            hosts = hosts.stream().filter(matchesPattern).collect(Collectors.toList());
        }
        if (!hostSelectors.isEmpty()) {
            List<HostSelector> selectors = hostSelectors.stream().map(selectorStr -> {
                HostSelector parsed = HostSelector.parse((String)selectorStr);
                if (parsed == null) {
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Invalid host selector: " + selectorStr)).build());
                }
                return parsed;
            }).collect(Collectors.toList());
            Map<String, Map<String, String>> hostsAndLabels = hosts.stream().collect(Collectors.toMap(Function.identity(), host -> this.model.getHostStatus((String)host).getLabels()));
            HostMatcher matcher = new HostMatcher(hostsAndLabels);
            hosts = matcher.getMatchingHosts(selectors);
        }
        return hosts;
    }

    @PUT
    @Path(value="{host}")
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public Response.Status put(@PathParam(value="host") String host, @QueryParam(value="id") @DefaultValue(value="") String id) {
        if (Strings.isNullOrEmpty((String)id)) {
            throw Responses.badRequest(new HostRegisterResponse(HostRegisterResponse.Status.INVALID_ID, host));
        }
        this.model.registerHost(host, id);
        log.info("added host {}", (Object)host);
        return Response.Status.OK;
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public HostDeregisterResponse delete(@PathParam(value="id") String host) {
        try {
            this.model.deregisterHost(host);
            return new HostDeregisterResponse(HostDeregisterResponse.Status.OK, host);
        }
        catch (HostNotFoundException e) {
            throw Responses.notFound(new HostDeregisterResponse(HostDeregisterResponse.Status.NOT_FOUND, host));
        }
        catch (HostStillInUseException e) {
            throw Responses.badRequest(new HostDeregisterResponse(HostDeregisterResponse.Status.JOBS_STILL_DEPLOYED, host));
        }
    }

    @GET
    @Path(value="{id}/status")
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public Optional<HostStatus> hostStatus(@PathParam(value="id") String host, @QueryParam(value="status") @DefaultValue(value="") String statusFilter) {
        HostStatus status = this.model.getHostStatus(host);
        Optional response = status != null && (Strings.isNullOrEmpty((String)statusFilter) || statusFilter.equals(status.getStatus().toString())) ? Optional.of((Object)status) : Optional.absent();
        log.debug("hostStatus: host={}, statusFilter={}, returning: {}", new Object[]{host, statusFilter, response});
        return response;
    }

    @POST
    @Path(value="/statuses")
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public Map<String, HostStatus> hostStatuses(List<String> hosts, @QueryParam(value="status") @DefaultValue(value="") String statusFilter) {
        HashMap statuses = Maps.newHashMap();
        for (String current : hosts) {
            HostStatus status = this.model.getHostStatus(current);
            if (status == null || !Strings.isNullOrEmpty((String)statusFilter) && !statusFilter.equals(status.getStatus().toString())) continue;
            statuses.put(current, status);
        }
        return statuses;
    }

    @PUT
    @Path(value="/{host}/jobs/{job}")
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public JobDeployResponse jobPut(@PathParam(value="host") String host, @PathParam(value="job") JobId jobId, @Valid Deployment deployment, @RequestUser String username, @QueryParam(value="token") @DefaultValue(value="") String token) {
        if (!jobId.isFullyQualified()) {
            throw Responses.badRequest(new JobDeployResponse(JobDeployResponse.Status.INVALID_ID, host, jobId));
        }
        try {
            Deployment actualDeployment = deployment.toBuilder().setDeployerUser(username).build();
            this.model.deployJob(host, actualDeployment, token);
            return new JobDeployResponse(JobDeployResponse.Status.OK, host, jobId);
        }
        catch (JobAlreadyDeployedException e) {
            throw Responses.badRequest(new JobDeployResponse(JobDeployResponse.Status.JOB_ALREADY_DEPLOYED, host, jobId));
        }
        catch (HostNotFoundException e) {
            throw Responses.badRequest(new JobDeployResponse(JobDeployResponse.Status.HOST_NOT_FOUND, host, jobId));
        }
        catch (JobDoesNotExistException e) {
            throw Responses.badRequest(new JobDeployResponse(JobDeployResponse.Status.JOB_NOT_FOUND, host, jobId));
        }
        catch (JobPortAllocationConflictException e) {
            throw Responses.badRequest(new JobDeployResponse(JobDeployResponse.Status.PORT_CONFLICT, host, jobId));
        }
        catch (TokenVerificationException e) {
            throw Responses.forbidden(new JobDeployResponse(JobDeployResponse.Status.FORBIDDEN, host, jobId));
        }
    }

    @DELETE
    @Path(value="/{host}/jobs/{job}")
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public JobUndeployResponse jobDelete(@PathParam(value="host") String host, @PathParam(value="job") JobId jobId, @QueryParam(value="token") @DefaultValue(value="") String token) {
        if (!jobId.isFullyQualified()) {
            throw Responses.badRequest(new JobUndeployResponse(JobUndeployResponse.Status.INVALID_ID, host, jobId));
        }
        try {
            this.model.undeployJob(host, jobId, token);
            return new JobUndeployResponse(JobUndeployResponse.Status.OK, host, jobId);
        }
        catch (HostNotFoundException e) {
            throw Responses.notFound(new JobUndeployResponse(JobUndeployResponse.Status.HOST_NOT_FOUND, host, jobId));
        }
        catch (JobNotDeployedException e) {
            throw Responses.notFound(new JobUndeployResponse(JobUndeployResponse.Status.JOB_NOT_FOUND, host, jobId));
        }
        catch (TokenVerificationException e) {
            throw Responses.forbidden(new JobUndeployResponse(JobUndeployResponse.Status.FORBIDDEN, host, jobId));
        }
    }

    @PATCH
    @Path(value="/{host}/jobs/{job}")
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public SetGoalResponse jobPatch(@PathParam(value="host") String host, @PathParam(value="job") JobId jobId, @Valid Deployment deployment, @QueryParam(value="token") @DefaultValue(value="") String token) {
        if (!deployment.getJobId().equals((Object)jobId)) {
            throw Responses.badRequest(new SetGoalResponse(SetGoalResponse.Status.ID_MISMATCH, host, jobId));
        }
        try {
            this.model.updateDeployment(host, deployment, token);
        }
        catch (HostNotFoundException e) {
            throw Responses.notFound(new SetGoalResponse(SetGoalResponse.Status.HOST_NOT_FOUND, host, jobId));
        }
        catch (JobNotDeployedException e) {
            throw Responses.notFound(new SetGoalResponse(SetGoalResponse.Status.JOB_NOT_DEPLOYED, host, jobId));
        }
        catch (TokenVerificationException e) {
            throw Responses.forbidden(new SetGoalResponse(SetGoalResponse.Status.FORBIDDEN, host, jobId));
        }
        log.info("patched job {} on host {}", (Object)deployment, (Object)host);
        return new SetGoalResponse(SetGoalResponse.Status.OK, host, jobId);
    }

    @GET
    @Path(value="/{host}/jobs/{job}")
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public Optional<Deployment> jobGet(@PathParam(value="host") String host, @PathParam(value="job") JobId jobId) {
        if (!jobId.isFullyQualified()) {
            throw Responses.badRequest();
        }
        return Optional.fromNullable((Object)this.model.getDeployment(host, jobId));
    }
}

