/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master.resources;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Strings;
import com.spotify.helios.common.PomVersion;
import com.spotify.helios.common.VersionCheckResponse;
import com.spotify.helios.common.VersionCompatibility;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="version")
public class VersionResource {
    @GET
    @Produces(value={"text/plain"})
    @Timed
    @ExceptionMetered
    public String version() {
        return String.format("\"%s\"", "0.9.54");
    }

    @GET
    @Path(value="/check")
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public VersionCheckResponse versionCheck(@QueryParam(value="client") @DefaultValue(value="") String client) {
        PomVersion serverVersion = PomVersion.parse((String)"0.9.54");
        if (Strings.isNullOrEmpty((String)client)) {
            return new VersionCheckResponse(VersionCompatibility.Status.MISSING, serverVersion, "0.9.54");
        }
        PomVersion clientVersion = PomVersion.parse((String)client);
        VersionCompatibility.Status status = VersionCompatibility.getStatus((PomVersion)serverVersion, (PomVersion)clientVersion);
        return new VersionCheckResponse(status, serverVersion, "0.9.54");
    }
}

