/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.rollingupdate;

import com.google.common.collect.Maps;
import com.spotify.helios.common.descriptors.DeploymentGroup;
import com.spotify.helios.common.descriptors.RolloutTask;
import com.spotify.helios.rollingupdate.RollingUpdateError;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DeploymentGroupEventFactory {
    private Map<String, Object> createEvent(String eventType, DeploymentGroup deploymentGroup) {
        HashMap ev = Maps.newHashMap();
        ev.put("eventType", eventType);
        ev.put("timestamp", System.currentTimeMillis());
        ev.put("deploymentGroup", deploymentGroup);
        return ev;
    }

    private Map<String, Object> addTaskFields(Map<String, Object> ev, RolloutTask task) {
        ev.put("action", task.getAction());
        ev.put("target", task.getTarget());
        return ev;
    }

    public Map<String, Object> rollingUpdateTaskFailed(DeploymentGroup deploymentGroup, RolloutTask task, String error, RollingUpdateError errorCode) {
        return this.rollingUpdateTaskFailed(deploymentGroup, task, error, errorCode, Collections.emptyMap());
    }

    public Map<String, Object> rollingUpdateTaskFailed(DeploymentGroup deploymentGroup, RolloutTask task, String error, RollingUpdateError errorCode, Map<String, Object> metadata) {
        Map<String, Object> ev = this.createEvent("rollingUpdateTaskResult", deploymentGroup);
        ev.putAll(metadata);
        ev.put("success", 0);
        ev.put("error", error);
        ev.put("errorCode", (Object)errorCode);
        return this.addTaskFields(ev, task);
    }

    public Map<String, Object> rollingUpdateTaskSucceeded(DeploymentGroup deploymentGroup, RolloutTask task) {
        Map<String, Object> ev = this.createEvent("rollingUpdateTaskResult", deploymentGroup);
        ev.put("success", 1);
        return this.addTaskFields(ev, task);
    }

    public Map<String, Object> rollingUpdateStarted(DeploymentGroup deploymentGroup) {
        Map<String, Object> ev = this.createEvent("rollingUpdateStarted", deploymentGroup);
        ev.put("reason", deploymentGroup.getRollingUpdateReason());
        return ev;
    }

    public Map<String, Object> rollingUpdateDone(DeploymentGroup deploymentGroup) {
        Map<String, Object> ev = this.createEvent("rollingUpdateFinished", deploymentGroup);
        ev.put("success", 1);
        return ev;
    }

    public Map<String, Object> rollingUpdateFailed(DeploymentGroup deploymentGroup, Map<String, Object> failEvent) {
        Map<String, Object> ev = this.createEvent("rollingUpdateFinished", deploymentGroup);
        ev.put("success", 0);
        ev.put("failedTask", failEvent);
        return ev;
    }
}

