/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.rollingupdate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.spotify.helios.common.descriptors.DeploymentGroup;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.RolloutTask;
import com.spotify.helios.rollingupdate.RolloutPlanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RollingUndeployPlanner
implements RolloutPlanner {
    private final DeploymentGroup deploymentGroup;

    private RollingUndeployPlanner(DeploymentGroup deploymentGroup) {
        this.deploymentGroup = (DeploymentGroup)Preconditions.checkNotNull((Object)deploymentGroup, (Object)"deploymentGroup");
    }

    public static RollingUndeployPlanner of(DeploymentGroup deploymentGroup) {
        return new RollingUndeployPlanner(deploymentGroup);
    }

    @Override
    public List<RolloutTask> plan(Map<String, HostStatus> hostsAndStatuses) {
        List hosts = hostsAndStatuses.entrySet().stream().filter(entry -> ((HostStatus)entry.getValue()).getStatus().equals((Object)HostStatus.Status.UP)).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
        ArrayList rolloutTasks = Lists.newArrayList();
        int parallelism = this.deploymentGroup.getRolloutOptions() != null ? this.deploymentGroup.getRolloutOptions().getParallelism() : 1;
        Lists.partition(hosts, (int)parallelism).forEach(partition -> rolloutTasks.addAll(this.rolloutTasks((List<String>)partition)));
        return ImmutableList.copyOf((Collection)rolloutTasks);
    }

    private List<RolloutTask> rolloutTasks(List<String> hosts) {
        ImmutableList.Builder tasks = ImmutableList.builder();
        hosts.forEach(host -> tasks.add((Object)RolloutTask.of((RolloutTask.Action)RolloutTask.Action.FORCE_UNDEPLOY_JOBS, (String)host)));
        hosts.forEach(host -> {
            tasks.add((Object)RolloutTask.of((RolloutTask.Action)RolloutTask.Action.AWAIT_UNDEPLOYED, (String)host));
            tasks.add((Object)RolloutTask.of((RolloutTask.Action)RolloutTask.Action.MARK_UNDEPLOYED, (String)host));
        });
        return tasks.build();
    }
}

