/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.rollingupdate;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.spotify.helios.common.descriptors.DeploymentGroup;
import com.spotify.helios.common.descriptors.DeploymentGroupStatus;
import com.spotify.helios.common.descriptors.DeploymentGroupTasks;
import com.spotify.helios.common.descriptors.Descriptor;
import com.spotify.helios.common.descriptors.RolloutTask;
import com.spotify.helios.rollingupdate.DeploymentGroupEventFactory;
import com.spotify.helios.rollingupdate.RollingUpdateError;
import com.spotify.helios.rollingupdate.RollingUpdateOp;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.ZooKeeperOperation;
import com.spotify.helios.servicescommon.coordination.ZooKeeperOperations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class RollingUpdateOpFactory {
    private final DeploymentGroupTasks tasks;
    private final DeploymentGroup deploymentGroup;
    private final DeploymentGroupEventFactory eventFactory;

    public RollingUpdateOpFactory(DeploymentGroupTasks tasks, DeploymentGroupEventFactory eventFactory) {
        this.tasks = tasks;
        this.deploymentGroup = tasks.getDeploymentGroup();
        this.eventFactory = eventFactory;
    }

    public RollingUpdateOp start(DeploymentGroup deploymentGroup, ZooKeeperClient client) throws KeeperException {
        DeploymentGroupStatus status;
        client.ensurePath(Paths.statusDeploymentGroupTasks());
        ArrayList ops = Lists.newArrayList();
        ArrayList events = Lists.newArrayList();
        List rolloutTasks = this.tasks.getRolloutTasks();
        events.add(this.eventFactory.rollingUpdateStarted(deploymentGroup));
        Stat tasksStat = client.exists(Paths.statusDeploymentGroupTasks(deploymentGroup.getName()));
        if (tasksStat == null) {
            ops.add(ZooKeeperOperations.create(Paths.statusDeploymentGroupTasks(deploymentGroup.getName())));
        }
        if (rolloutTasks.isEmpty()) {
            status = DeploymentGroupStatus.newBuilder().setState(DeploymentGroupStatus.State.DONE).build();
            ops.add(ZooKeeperOperations.delete(Paths.statusDeploymentGroupTasks(deploymentGroup.getName())));
            events.add(this.eventFactory.rollingUpdateDone(deploymentGroup));
        } else {
            DeploymentGroupTasks tasks = DeploymentGroupTasks.newBuilder().setRolloutTasks(rolloutTasks).setTaskIndex(0).setDeploymentGroup(deploymentGroup).build();
            status = DeploymentGroupStatus.newBuilder().setState(DeploymentGroupStatus.State.ROLLING_OUT).build();
            ops.add(ZooKeeperOperations.set(Paths.statusDeploymentGroupTasks(deploymentGroup.getName()), (Descriptor)tasks));
        }
        ops.add(ZooKeeperOperations.set(Paths.statusDeploymentGroup(deploymentGroup.getName()), (Descriptor)status));
        return new RollingUpdateOp((ImmutableList<ZooKeeperOperation>)ImmutableList.copyOf((Collection)ops), (ImmutableList<Map<String, Object>>)ImmutableList.copyOf((Collection)events));
    }

    public RollingUpdateOp nextTask() {
        return this.nextTask(Collections.emptyList());
    }

    public RollingUpdateOp nextTask(List<ZooKeeperOperation> operations) {
        ArrayList ops = Lists.newArrayList(operations);
        ArrayList events = Lists.newArrayList();
        RolloutTask task = (RolloutTask)this.tasks.getRolloutTasks().get(this.tasks.getTaskIndex());
        if (this.tasks.getTaskIndex() + 1 == this.tasks.getRolloutTasks().size()) {
            DeploymentGroupStatus status = DeploymentGroupStatus.newBuilder().setState(DeploymentGroupStatus.State.DONE).build();
            ops.add(ZooKeeperOperations.delete(Paths.statusDeploymentGroupTasks(this.deploymentGroup.getName())));
            ops.add(ZooKeeperOperations.set(Paths.statusDeploymentGroup(this.deploymentGroup.getName()), (Descriptor)status));
            events.add(this.eventFactory.rollingUpdateDone(this.deploymentGroup));
        } else {
            ops.add(ZooKeeperOperations.set(Paths.statusDeploymentGroupTasks(this.deploymentGroup.getName()), (Descriptor)this.tasks.toBuilder().setTaskIndex(this.tasks.getTaskIndex() + 1).build()));
            if (!operations.isEmpty()) {
                events.add(this.eventFactory.rollingUpdateTaskSucceeded(this.deploymentGroup, task));
            }
        }
        return new RollingUpdateOp((ImmutableList<ZooKeeperOperation>)ImmutableList.copyOf((Collection)ops), (ImmutableList<Map<String, Object>>)ImmutableList.copyOf((Collection)events));
    }

    public RollingUpdateOp yield() {
        return new RollingUpdateOp((ImmutableList<ZooKeeperOperation>)ImmutableList.of(), (ImmutableList<Map<String, Object>>)ImmutableList.of());
    }

    public RollingUpdateOp error(String msg, String host, RollingUpdateError errorCode, Map<String, Object> metadata) {
        ArrayList operations = Lists.newArrayList();
        String errMsg = Strings.isNullOrEmpty((String)host) ? msg : host + ": " + msg;
        DeploymentGroupStatus status = DeploymentGroupStatus.newBuilder().setState(DeploymentGroupStatus.State.FAILED).setError(errMsg).build();
        operations.add(ZooKeeperOperations.delete(Paths.statusDeploymentGroupTasks(this.deploymentGroup.getName())));
        operations.add(ZooKeeperOperations.set(Paths.statusDeploymentGroup(this.deploymentGroup.getName()), (Descriptor)status));
        RolloutTask task = (RolloutTask)this.tasks.getRolloutTasks().get(this.tasks.getTaskIndex());
        ArrayList events = Lists.newArrayList();
        Map<String, Object> taskEv = this.eventFactory.rollingUpdateTaskFailed(this.deploymentGroup, task, errMsg, errorCode, metadata);
        events.add(taskEv);
        events.add(this.eventFactory.rollingUpdateFailed(this.deploymentGroup, taskEv));
        return new RollingUpdateOp((ImmutableList<ZooKeeperOperation>)ImmutableList.copyOf((Collection)operations), (ImmutableList<Map<String, Object>>)ImmutableList.copyOf((Collection)events));
    }

    public RollingUpdateOp error(String msg, String host, RollingUpdateError errorCode) {
        return this.error(msg, host, errorCode, Collections.emptyMap());
    }

    public RollingUpdateOp error(Exception e, String host, RollingUpdateError errorCode) {
        String message = errorCode == RollingUpdateError.PORT_CONFLICT ? e.getMessage() + " (the conflicting job was deployed manually or by a different deployment group)" : e.getMessage();
        return this.error(message, host, errorCode);
    }
}

