/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.rollingupdate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.spotify.helios.common.descriptors.DeploymentGroup;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.RolloutTask;
import com.spotify.helios.rollingupdate.RolloutPlanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class RollingUpdatePlanner
implements RolloutPlanner {
    private final DeploymentGroup deploymentGroup;

    private RollingUpdatePlanner(DeploymentGroup deploymentGroup) {
        this.deploymentGroup = (DeploymentGroup)Preconditions.checkNotNull((Object)deploymentGroup, (Object)"deploymentGroup");
    }

    public static RollingUpdatePlanner of(DeploymentGroup deploymentGroup) {
        return new RollingUpdatePlanner(deploymentGroup);
    }

    @Override
    public List<RolloutTask> plan(Map<String, HostStatus> hostsAndStatuses) {
        ArrayList hosts = Lists.newArrayList();
        for (Map.Entry<String, HostStatus> entry : hostsAndStatuses.entrySet()) {
            if (!entry.getValue().getStatus().equals((Object)HostStatus.Status.UP)) continue;
            hosts.add(entry.getKey());
        }
        ArrayList rolloutTasks = Lists.newArrayList();
        int parallelism = this.deploymentGroup.getRolloutOptions() != null ? this.deploymentGroup.getRolloutOptions().getParallelism() : 1;
        boolean overlap = this.deploymentGroup.getRolloutOptions() != null && this.deploymentGroup.getRolloutOptions().getOverlap();
        for (List partition : Lists.partition((List)hosts, (int)parallelism)) {
            rolloutTasks.addAll(overlap ? this.rolloutTasksWithOverlap(partition) : this.rolloutTasks(partition));
        }
        return ImmutableList.copyOf((Collection)rolloutTasks);
    }

    private List<RolloutTask> rolloutTasks(List<String> hosts) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (String host : hosts) {
            result.add((Object)RolloutTask.of((RolloutTask.Action)RolloutTask.Action.UNDEPLOY_OLD_JOBS, (String)host));
            result.add((Object)RolloutTask.of((RolloutTask.Action)RolloutTask.Action.DEPLOY_NEW_JOB, (String)host));
        }
        for (String host : hosts) {
            result.add((Object)RolloutTask.of((RolloutTask.Action)RolloutTask.Action.AWAIT_RUNNING, (String)host));
        }
        return result.build();
    }

    private List<RolloutTask> rolloutTasksWithOverlap(List<String> hosts) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (String host : hosts) {
            result.add((Object)RolloutTask.of((RolloutTask.Action)RolloutTask.Action.DEPLOY_NEW_JOB, (String)host));
        }
        for (String host : hosts) {
            result.add((Object)RolloutTask.of((RolloutTask.Action)RolloutTask.Action.AWAIT_RUNNING, (String)host));
        }
        for (String host : hosts) {
            result.add((Object)RolloutTask.of((RolloutTask.Action)RolloutTask.Action.UNDEPLOY_OLD_JOBS, (String)host));
        }
        return result.build();
    }
}

