/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.rollingupdate;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AbstractIdleService;
import com.spotify.helios.common.descriptors.DeploymentGroup;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.master.HostMatcher;
import com.spotify.helios.master.MasterModel;
import com.spotify.helios.servicescommon.Reactor;
import com.spotify.helios.servicescommon.ReactorFactory;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollingUpdateService
extends AbstractIdleService {
    private static final Logger log = LoggerFactory.getLogger(RollingUpdateService.class);
    private static final long UPDATE_INTERVAL = TimeUnit.SECONDS.toMillis(1L);
    private static final long HOST_UPDATE_INTERVAL = TimeUnit.SECONDS.toMillis(1L);
    private final MasterModel masterModel;
    private final Reactor hostUpdateReactor;
    private final Reactor rollingUpdateReactor;

    public RollingUpdateService(MasterModel masterModel, ReactorFactory reactorFactory) {
        this.masterModel = (MasterModel)Preconditions.checkNotNull((Object)masterModel, (Object)"masterModel");
        Preconditions.checkNotNull((Object)reactorFactory, (Object)"reactorFactory");
        this.hostUpdateReactor = reactorFactory.create("hostUpdate", new UpdateDeploymentGroupHosts(), HOST_UPDATE_INTERVAL);
        this.rollingUpdateReactor = reactorFactory.create("rollingUpdate", new RollingUpdate(), UPDATE_INTERVAL);
    }

    protected void startUp() throws Exception {
        this.hostUpdateReactor.startAsync().awaitRunning();
        this.hostUpdateReactor.signal();
        this.rollingUpdateReactor.startAsync().awaitRunning();
        this.rollingUpdateReactor.signal();
    }

    protected void shutDown() throws Exception {
        this.hostUpdateReactor.stopAsync().awaitTerminated();
        this.rollingUpdateReactor.stopAsync().awaitTerminated();
    }

    private class RollingUpdate
    implements Reactor.Callback {
        private RollingUpdate() {
        }

        @Override
        public void run(boolean timeout) throws InterruptedException {
            try {
                RollingUpdateService.this.masterModel.rollingUpdateStep();
            }
            catch (Exception e) {
                log.error("error processing rolling update step: {}", (Throwable)e);
            }
        }
    }

    private class UpdateDeploymentGroupHosts
    implements Reactor.Callback {
        private UpdateDeploymentGroupHosts() {
        }

        @Override
        public void run(boolean timeout) throws InterruptedException {
            List<String> allHosts = RollingUpdateService.this.masterModel.listHosts();
            HashMap hostsToLabels = Maps.newHashMap();
            for (String host : allHosts) {
                HostStatus hostStatus = RollingUpdateService.this.masterModel.getHostStatus(host);
                if (hostStatus == null) continue;
                hostsToLabels.put(host, hostStatus.getLabels());
            }
            HostMatcher hostMatcher = new HostMatcher(hostsToLabels);
            for (DeploymentGroup dg : RollingUpdateService.this.masterModel.getDeploymentGroups().values()) {
                List<String> matchingHosts = hostMatcher.getMatchingHosts(dg);
                try {
                    RollingUpdateService.this.masterModel.updateDeploymentGroupHosts(dg.getName(), matchingHosts);
                }
                catch (Exception e) {
                    log.warn("error processing hosts update for deployment group: {} - {}", (Object)dg.getName(), (Object)e);
                }
            }
        }
    }
}

