/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.spotify.helios.servicescommon.InterruptingExecutionThreadService;
import com.spotify.helios.servicescommon.Reactor;
import java.io.InterruptedIOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReactor
extends InterruptingExecutionThreadService
implements Reactor {
    private static final Logger log = LoggerFactory.getLogger(DefaultReactor.class);
    private final Semaphore semaphore = new Semaphore(0);
    private final String name;
    private final Reactor.Callback callback;
    private final long timeoutMillis;

    public DefaultReactor(String name, Reactor.Callback callback, long timeoutMillis) {
        super("Reactor(" + name + ")");
        this.name = name;
        this.callback = callback;
        this.timeoutMillis = timeoutMillis;
    }

    public DefaultReactor(String name, Reactor.Callback callback) {
        this(name, callback, 0L);
    }

    @Override
    public void signal() {
        this.semaphore.release();
    }

    @Override
    public Runnable signalRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                DefaultReactor.this.signal();
            }
        };
    }

    protected void run() throws Exception {
        while (this.isRunning()) {
            boolean timeout;
            try {
                if (this.timeoutMillis == 0L) {
                    this.semaphore.acquire();
                    timeout = false;
                } else {
                    timeout = !this.semaphore.tryAcquire(this.timeoutMillis, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException e) {
                continue;
            }
            this.semaphore.drainPermits();
            try {
                this.callback.run(timeout);
            }
            catch (InterruptedException e) {
                log.debug("reactor interrupted: {}", (Object)this.name);
            }
            catch (Exception e) {
                if (e.getCause() instanceof ClosedByInterruptException || e.getCause() instanceof InterruptedIOException || e.getCause() instanceof InterruptedException) {
                    log.debug("reactor interrupted: {}", (Object)this.name);
                    continue;
                }
                log.error("reactor runner threw exception: {}", (Object)this.name, (Object)e);
            }
        }
    }
}

