/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.google.cloud.pubsub.PubSub;
import com.google.cloud.pubsub.PubSubOptions;
import com.spotify.helios.servicescommon.GooglePubSubSender;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GooglePubSubProvider {
    private static final Logger log = LoggerFactory.getLogger(GooglePubSubProvider.class);
    private final List<String> pubsubPrefixes;

    public GooglePubSubProvider(List<String> pubsubPrefixes) {
        this.pubsubPrefixes = pubsubPrefixes;
    }

    public List<GooglePubSubSender> senders() {
        return this.senders(() -> (PubSub)PubSubOptions.getDefaultInstance().getService());
    }

    public List<GooglePubSubSender> senders(Supplier<PubSub> pubsubSupplier) {
        if (this.pubsubPrefixes != null && !this.pubsubPrefixes.isEmpty()) {
            try {
                PubSub pubsub = pubsubSupplier.get();
                return this.pubsubPrefixes.stream().map(prefix -> new GooglePubSubSender(pubsub, (String)prefix)).collect(Collectors.toList());
            }
            catch (Exception e) {
                log.warn("Failed to set up google pubsub service", (Throwable)e);
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }
}

