/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.google.cloud.ByteArray;
import com.google.cloud.pubsub.Message;
import com.google.cloud.pubsub.PubSub;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.JdkFutureAdapters;
import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.helios.servicescommon.EventSender;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GooglePubSubSender
implements EventSender {
    private static final Logger log = LoggerFactory.getLogger(GooglePubSubSender.class);
    private final PubSub pubsub;
    private final String topicPrefix;

    public GooglePubSubSender(PubSub pubSub, String topicPrefix) {
        this.pubsub = pubSub;
        this.topicPrefix = topicPrefix;
    }

    @Override
    public void send(String topic, byte[] message) {
        final String combinedTopic = this.topicPrefix + topic;
        try {
            Futures.addCallback((ListenableFuture)JdkFutureAdapters.listenInPoolThread((Future)this.pubsub.publishAsync(combinedTopic, Message.of((ByteArray)ByteArray.copyFrom((byte[])message)))), (FutureCallback)new FutureCallback<String>(){

                public void onSuccess(@Nullable String ackId) {
                    log.debug("Sent an event to Google PubSub, topic: {}, ack: {}", (Object)combinedTopic, (Object)ackId);
                }

                public void onFailure(Throwable t) {
                    log.warn("Unable to send an event to Google PubSub, topic: {}", (Object)combinedTopic, (Object)t);
                }
            });
        }
        catch (Exception e) {
            log.warn("Failed to publish Google PubSub message, topic: {}", (Object)combinedTopic, (Object)e);
        }
    }
}

