/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaClientProvider {
    private static final Logger log = LoggerFactory.getLogger(KafkaClientProvider.class);
    private static final String KAFKA_HELIOS_CLIENT_ID = "Helios";
    private static final String KAFKA_QUORUM_PARAMETER = "1";
    public static final int MAX_BLOCK_TIMEOUT = 1000;
    private final Optional<Map<String, Object>> partialConfigs;

    public KafkaClientProvider(@Nullable List<String> brokerList) {
        this.partialConfigs = Optional.ofNullable(brokerList).map(input -> ImmutableMap.builder().put((Object)"bootstrap.servers", (Object)Joiner.on((char)',').join((Iterable)input)).put((Object)"client.id", (Object)KAFKA_HELIOS_CLIENT_ID).put((Object)"acks", (Object)KAFKA_QUORUM_PARAMETER).put((Object)"metadata.fetch.timeout.ms", (Object)1000).put((Object)"block.on.buffer.full", (Object)false).build());
    }

    public Optional<KafkaProducer<String, byte[]>> getDefaultProducer() {
        return this.getProducer((Serializer)new StringSerializer(), (Serializer)new ByteArraySerializer());
    }

    public <K, V> Optional<KafkaProducer<K, V>> getProducer(@NotNull Serializer<K> keySerializer, @NotNull Serializer<V> valueSerializer) {
        try {
            return this.partialConfigs.map(input -> new KafkaProducer(input, keySerializer, valueSerializer));
        }
        catch (Exception e) {
            log.warn("error while generating KafkaProducer - {}", (Throwable)e);
            return Optional.empty();
        }
    }
}

