/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.spotify.helios.servicescommon.EventSender;
import com.spotify.helios.servicescommon.KafkaRecord;
import java.util.Optional;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSender
implements EventSender {
    private static final Logger log = LoggerFactory.getLogger(KafkaSender.class);
    private final Optional<KafkaProducer<String, byte[]>> kafkaProducer;

    public KafkaSender(Optional<KafkaProducer<String, byte[]>> kafkaProducer) {
        this.kafkaProducer = kafkaProducer;
    }

    public void send(KafkaRecord kafkaRecord) {
        if (this.kafkaProducer.isPresent()) {
            ProducerRecord record = new ProducerRecord(kafkaRecord.getKafkaTopic(), (Object)kafkaRecord.getKafkaData());
            this.kafkaProducer.get().send(record, (Callback)new LoggingCallback());
        } else {
            log.debug("KafkaProducer isn't set. Not sending anything.");
        }
    }

    @Override
    public void send(String topic, byte[] message) {
        this.send(KafkaRecord.of(topic, message));
    }

    private static class LoggingCallback
    implements Callback {
        private LoggingCallback() {
        }

        public void onCompletion(RecordMetadata metadata, Exception e) {
            if (e == null) {
                log.debug("Sent an event to Kafka, meta: {}", (Object)metadata);
            } else {
                log.warn("Unable to send an event to Kafka", (Throwable)e);
            }
        }
    }
}

