/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.readytalk.metrics.StatsDReporter;
import io.dropwizard.lifecycle.Managed;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ManagedStatsdReporter
implements Managed {
    private static final int POLL_INTERVAL_SECONDS = 15;
    private final StatsDReporter statsdReporter;

    public ManagedStatsdReporter(String endpoint, MetricRegistry registry) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)endpoint) ? 1 : 0) != 0);
        List parts = Splitter.on((String)":").splitToList((CharSequence)endpoint);
        Preconditions.checkArgument((parts.size() == 2 ? 1 : 0) != 0, (Object)"Specification of statsd host port has wrong number of parts. Should be host:port");
        String host = (String)parts.get(0);
        int port = Integer.valueOf((String)parts.get(1));
        this.statsdReporter = StatsDReporter.forRegistry((MetricRegistry)registry).build(host, port);
    }

    public void start() throws Exception {
        this.statsdReporter.start(15L, TimeUnit.SECONDS);
    }

    public void stop() throws Exception {
        this.statsdReporter.close();
    }
}

