/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;

public class MasterRequestMetrics {
    private final Counter successCounter;
    private final Counter failureCounter;
    private final Counter userErrorCounter;
    private final Meter successMeter;
    private final Meter failureMeter;
    private final Meter userErrorMeter;

    public MasterRequestMetrics(String group, String type, String requestName, MetricRegistry registry) {
        String prefix = MetricRegistry.name((String)group, (String[])new String[]{type, requestName});
        this.successCounter = registry.counter(prefix + "_count_success");
        this.failureCounter = registry.counter(prefix + "_count_failures");
        this.userErrorCounter = registry.counter(prefix + "_count_usererror");
        this.successMeter = registry.meter(prefix + "_meter_success");
        this.failureMeter = registry.meter(prefix + "_meter_failures");
        this.userErrorMeter = registry.meter(prefix + "_meter_usererror");
    }

    public void success() {
        this.successCounter.inc();
        this.successMeter.mark();
    }

    public void failure() {
        this.failureCounter.inc();
        this.failureMeter.mark();
    }

    public void userError() {
        this.userErrorCounter.inc();
        this.userErrorMeter.mark();
    }

    public Counter getSuccessCounter() {
        return this.successCounter;
    }

    public Counter getFailureCounter() {
        return this.failureCounter;
    }

    public Counter getUserErrorCounter() {
        return this.failureCounter;
    }
}

