/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolverConfReader {
    private static final Logger log = LoggerFactory.getLogger(ResolverConfReader.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDomainFromResolverConf(String file) {
        try (FileInputStream in = new FileInputStream(file);){
            InputStreamReader isr = new InputStreamReader(in);
            try (BufferedReader br = new BufferedReader(isr);){
                StringTokenizer st;
                block34: {
                    String line;
                    while ((line = br.readLine()) != null) {
                        if (!line.startsWith("domain")) continue;
                        st = new StringTokenizer(line);
                        st.nextToken();
                        if (!st.hasMoreTokens()) {
                            continue;
                        }
                        break block34;
                    }
                    return "";
                }
                String string = st.nextToken();
                return string;
            }
        }
        catch (FileNotFoundException e) {
            log.warn("Resolver config file not found", (Throwable)e);
            return "";
        }
        catch (IOException e) {
            log.warn("Error reading config file", (Throwable)e);
        }
        return "";
    }
}

