/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.aphyr.riemann.client.AbstractRiemannClient;
import com.aphyr.riemann.client.RiemannClient;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.riemann.Riemann;
import com.codahale.metrics.riemann.RiemannReporter;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.spotify.helios.servicescommon.NoOpRiemannClient;
import com.spotify.helios.servicescommon.RiemannFacade;
import io.dropwizard.lifecycle.Managed;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class RiemannSupport
implements Managed {
    private final String host;
    private final int port;
    private final MetricRegistry metricsRegistry;
    private final String serviceName;
    private final String hostName;
    private RiemannClient client = null;
    private RiemannReporter riemannReporter;
    private final String proto;

    public RiemannSupport(MetricRegistry metricsRegistry, String hostPort, String hostName, String serviceName) {
        this.metricsRegistry = metricsRegistry;
        this.serviceName = serviceName;
        this.hostName = hostName;
        if (Strings.isNullOrEmpty((String)hostPort)) {
            this.host = null;
            this.port = 0;
            this.proto = null;
            return;
        }
        Iterable parts = Splitter.on((String)":").split((CharSequence)hostPort);
        int size = Iterables.size((Iterable)parts);
        if (size > 3 || size < 2) {
            throw new RuntimeException("specification of riemann host port has wrong number of parts.  Should be [proto:]host:port, where proto is udp or tcp");
        }
        this.proto = size == 3 ? (String)Iterables.get((Iterable)parts, (int)0) : "udp";
        Preconditions.checkState(("udp".equals(this.proto) || "tcp".equals(this.proto) ? 1 : 0) != 0);
        this.host = (String)Iterables.get((Iterable)parts, (int)(size - 2));
        this.port = Integer.valueOf((String)Iterables.get((Iterable)parts, (int)(size - 1)));
    }

    public RiemannFacade getFacade() {
        RiemannClient cli = this.getClient();
        if (cli == null) {
            return new NoOpRiemannClient().facade();
        }
        return new RiemannFacade((AbstractRiemannClient)cli, this.hostName, this.serviceName);
    }

    private RiemannClient getClient() {
        if (this.host == null) {
            return null;
        }
        if (this.client == null) {
            try {
                if ("udp".equals(this.proto)) {
                    this.client = RiemannClient.udp((String)this.host, (int)this.port);
                } else if ("tcp".equals(this.proto)) {
                    this.client = RiemannClient.tcp((String)this.host, (int)this.port);
                } else {
                    throw new IllegalArgumentException();
                }
                this.client.connect();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.client;
    }

    public RiemannReporter getReporter() {
        if (this.host == null) {
            return null;
        }
        return RiemannReporter.forRegistry((MetricRegistry)this.metricsRegistry).localHost(this.hostName).build(new Riemann((AbstractRiemannClient)this.getClient()));
    }

    public void start() throws Exception {
        this.riemannReporter = this.getReporter();
        if (this.riemannReporter != null) {
            this.riemannReporter.start(15L, TimeUnit.SECONDS);
        }
    }

    public void stop() throws Exception {
        if (this.riemannReporter != null) {
            this.riemannReporter.close();
        }
    }
}

