/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;

public class RuleBasedZooKeeperAclProvider
implements ACLProvider {
    private final ImmutableList<ACL> defaultAcl;
    private final ImmutableList<Rule> rules;

    public static Builder builder() {
        return new Builder();
    }

    private RuleBasedZooKeeperAclProvider(ImmutableList<Rule> rules, ImmutableList<ACL> defaultAcl) {
        this.rules = rules;
        this.defaultAcl = defaultAcl;
    }

    public List<ACL> getDefaultAcl() {
        return this.defaultAcl;
    }

    public List<ACL> getAclForPath(String path) {
        HashMap matching = Maps.newHashMap();
        for (Rule rule : this.rules) {
            if (!rule.matches(path)) continue;
            int existingPerms = matching.containsKey(rule.id) ? (Integer)matching.get(rule.id) : 0;
            matching.put(rule.id, rule.perms | existingPerms);
        }
        if (matching.isEmpty()) {
            return null;
        }
        ArrayList acls = Lists.newArrayList();
        for (Map.Entry e : matching.entrySet()) {
            acls.add(new ACL(((Integer)e.getValue()).intValue(), (Id)e.getKey()));
        }
        return acls;
    }

    public static class Builder {
        private final List<Rule> rules = Lists.newArrayList();
        private ImmutableList<ACL> defaultAcl = ImmutableList.copyOf((Collection)ZooDefs.Ids.READ_ACL_UNSAFE);

        Builder defaultAcl(ACL ... acls) {
            return this.defaultAcl(Arrays.asList(acls));
        }

        Builder defaultAcl(List<ACL> defaultAcl) {
            this.defaultAcl = ImmutableList.copyOf(defaultAcl);
            return this;
        }

        Builder rule(String pathRegex, int permissions, Id id) {
            this.rules.add(new Rule(pathRegex, permissions, id));
            return this;
        }

        RuleBasedZooKeeperAclProvider build() {
            return new RuleBasedZooKeeperAclProvider(ImmutableList.copyOf(this.rules), this.defaultAcl);
        }
    }

    private static class Rule {
        private final Pattern pattern;
        private final Id id;
        private final int perms;

        Rule(String regex, int perms, Id id) {
            this.pattern = Pattern.compile(regex);
            this.perms = perms;
            this.id = id;
        }

        boolean matches(String path) {
            return this.pattern.matcher(path).matches();
        }
    }
}

