/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.AbstractIdleService;
import com.spotify.helios.common.LoggingConfig;
import com.spotify.logging.LoggingConfigurator;
import io.dropwizard.jackson.Jackson;
import io.dropwizard.setup.Environment;
import io.dropwizard.validation.valuehandling.OptionalValidatedValueUnwrapper;
import java.io.File;
import java.util.Arrays;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.spi.valuehandling.ValidatedValueUnwrapper;
import org.slf4j.bridge.SLF4JBridgeHandler;

public abstract class ServiceMain
extends AbstractIdleService {
    protected ServiceMain(LoggingConfig loggingConfig, String sentryDsn) {
        ServiceMain.setupLogging(loggingConfig, sentryDsn);
    }

    protected static Environment createEnvironment(String name) {
        Validator validator = ((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).addValidatedValueHandler((ValidatedValueUnwrapper)new OptionalValidatedValueUnwrapper()).buildValidatorFactory().getValidator();
        return new Environment(name, Jackson.newObjectMapper(), validator, new MetricRegistry(), Thread.currentThread().getContextClassLoader());
    }

    protected static void setupLogging(LoggingConfig config, String sentryDsn) {
        if (config.getNoLogSetup()) {
            return;
        }
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        int verbose = config.getVerbosity();
        LoggingConfigurator.Level level = (LoggingConfigurator.Level)Iterables.get(Arrays.asList(LoggingConfigurator.Level.INFO, LoggingConfigurator.Level.DEBUG, LoggingConfigurator.Level.ALL), (int)verbose, (Object)LoggingConfigurator.Level.ALL);
        File logconfig = config.getConfigFile();
        if (logconfig != null) {
            LoggingConfigurator.configure((File)logconfig);
        } else {
            if (config.isSyslog()) {
                LoggingConfigurator.configureSyslogDefaults((String)"helios", (LoggingConfigurator.Level)level);
            } else {
                LoggingConfigurator.configureDefaults((String)"helios", (LoggingConfigurator.Level)level);
            }
            if (!Strings.isNullOrEmpty((String)sentryDsn)) {
                LoggingConfigurator.addSentryAppender((String)sentryDsn);
            }
        }
    }
}

