/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.io.CharStreams;
import com.spotify.helios.common.LoggingConfig;
import com.spotify.helios.servicescommon.FastForwardConfig;
import com.spotify.helios.servicescommon.ResolverConfReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;

public class ServiceParser {
    private final Namespace options;
    private final Argument nameArg;
    private final Argument sentryDsnArg;
    private final Argument domainArg;
    private final Argument serviceRegistryArg;
    private final Argument serviceRegistrarPluginArg;
    private final Argument zooKeeperConnectStringArg;
    private final Argument zooKeeperSessiontimeoutArg;
    private final Argument zooKeeperConnectiontimeoutArg;
    private final Argument zooKeeperClusterId;
    private final Argument noZooKeeperRegistrationArg;
    private final Argument zooKeeperEnableAcls;
    private final Argument zooKeeperAclMasterUser;
    private final Argument zooKeeperAclAgentUser;
    private final Argument noMetricsArg;
    private final Argument statsdHostPortArg;
    private final Argument riemannHostPortArg;
    private final Argument verboseArg;
    private final Argument syslogArg;
    private final Argument logconfigArg;
    private final Argument noLogSetupArg;
    private final Argument kafkaArg;
    private final Argument pubsubTopicPrefixArg;
    private final Argument stateDirArg;
    private final Argument ffwdEnabled;
    private final Argument ffwdAddress;
    private final Argument ffwdInterval;
    private final Argument ffwdMetricKey;

    public ServiceParser(String programName, String description, String ... args) throws ArgumentParserException {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)programName).defaultHelp(true).description(description);
        this.nameArg = parser.addArgument(new String[]{"--name"}).setDefault((Object)ServiceParser.getHostName()).help("hostname to register as");
        this.domainArg = parser.addArgument(new String[]{"--domain"}).setDefault((Object)ResolverConfReader.getDomainFromResolverConf("/etc/resolv.conf")).help("Service registration domain.");
        this.serviceRegistryArg = parser.addArgument(new String[]{"--service-registry"}).help("Service registry address. Overrides domain.");
        this.serviceRegistrarPluginArg = parser.addArgument(new String[]{"--service-registrar-plugin"}).type((ArgumentType)Arguments.fileType().verifyExists().verifyCanRead()).help("Service registration plugin.");
        this.zooKeeperConnectStringArg = parser.addArgument(new String[]{"--zk"}).setDefault((Object)"localhost:2181").help("zookeeper connection string");
        this.zooKeeperSessiontimeoutArg = parser.addArgument(new String[]{"--zk-session-timeout"}).type(Integer.class).setDefault((Object)((int)TimeUnit.SECONDS.toMillis(60L))).help("zookeeper session timeout");
        this.zooKeeperConnectiontimeoutArg = parser.addArgument(new String[]{"--zk-connection-timeout"}).type(Integer.class).setDefault((Object)((int)TimeUnit.SECONDS.toMillis(15L))).help("zookeeper connection timeout");
        this.zooKeeperClusterId = parser.addArgument(new String[]{"--zk-cluster-id"}).type(String.class).setDefault((Object)null).help("Optional cluster ID to ensure we are connected to the right cluster");
        this.noZooKeeperRegistrationArg = parser.addArgument(new String[]{"--no-zk-registration"}).setDefault(Arguments.SUPPRESS).action((ArgumentAction)Arguments.storeTrue()).help("Do not register this master in zookeeper. Useful for debugging.");
        this.zooKeeperEnableAcls = parser.addArgument(new String[]{"--zk-enable-acls"}).action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false).help("Enable zookeeper ACLs.");
        this.zooKeeperAclMasterUser = parser.addArgument(new String[]{"--zk-acl-master-user"}).type(String.class).setDefault((Object)"helios-master").help("zookeeper ACL username used for masters.");
        this.zooKeeperAclAgentUser = parser.addArgument(new String[]{"--zk-acl-agent-user"}).type(String.class).setDefault((Object)"helios-agent").help("zookeeper ACL username used for agents.");
        this.noMetricsArg = parser.addArgument(new String[]{"--no-metrics"}).setDefault(Arguments.SUPPRESS).action((ArgumentAction)Arguments.storeTrue()).help("Turn off all collection and reporting of metrics");
        this.statsdHostPortArg = parser.addArgument(new String[]{"--statsd-host-port"}).setDefault((Object)null).help("host:port of where to send statsd metrics (to be useful, --no-metrics must *NOT* be specified)");
        this.riemannHostPortArg = parser.addArgument(new String[]{"--riemann-host-port"}).setDefault((Object)null).help("host:port of where to send riemann events and metrics (to be useful, --no-metrics must *NOT* be specified)");
        this.verboseArg = parser.addArgument(new String[]{"-v", "--verbose"}).action((ArgumentAction)Arguments.count());
        this.syslogArg = parser.addArgument(new String[]{"--syslog"}).help("Log to syslog.").action((ArgumentAction)Arguments.storeTrue());
        this.logconfigArg = parser.addArgument(new String[]{"--logconfig"}).type((ArgumentType)Arguments.fileType().verifyExists().verifyCanRead()).help("Logback configuration file.");
        this.noLogSetupArg = parser.addArgument(new String[]{"--no-log-setup"}).action((ArgumentAction)Arguments.storeTrue()).help(Arguments.SUPPRESS);
        this.sentryDsnArg = parser.addArgument(new String[]{"--sentry-dsn"}).setDefault((Object)null).help("The sentry data source name");
        this.kafkaArg = parser.addArgument(new String[]{"--kafka"}).action((ArgumentAction)Arguments.append()).setDefault(new ArrayList()).help("Kafka brokers to bootstrap with");
        this.pubsubTopicPrefixArg = parser.addArgument(new String[]{"--pubsub-topic-prefix"}).action((ArgumentAction)Arguments.append()).setDefault(new ArrayList()).help("Google pubsub topic prefixes to send to");
        this.stateDirArg = parser.addArgument(new String[]{"--state-dir"}).setDefault((Object)".").help("Directory for persisting state locally.");
        this.ffwdEnabled = parser.addArgument(new String[]{"--ffwd-enabled"}).action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false).help("Enables reporting of metrics to FastForward. Only functional when --no-metrics is not set.");
        this.ffwdAddress = parser.addArgument(new String[]{"--ffwd-address"}).help("Overrides the default FastForward address, should contain host and port like `host:port`.");
        this.ffwdInterval = parser.addArgument(new String[]{"--ffwd-interval-secs"}).type(Integer.class).setDefault((Object)30).help("Interval in seconds at which to report metrics to FastForward.");
        this.ffwdMetricKey = parser.addArgument(new String[]{"--ffwd-key"}).setDefault((Object)programName).help("Value to use for `key` in metric data sent to FastForward. Defaults to '" + programName + "'");
        this.addArgs(parser);
        try {
            this.options = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            throw e;
        }
    }

    protected void addArgs(ArgumentParser parser) {
    }

    public Namespace getNamespace() {
        return this.options;
    }

    public LoggingConfig getLoggingConfig() {
        return new LoggingConfig(this.options.getInt(this.verboseArg.getDest()).intValue(), this.options.getBoolean(this.syslogArg.getDest()).booleanValue(), (File)this.options.get(this.logconfigArg.getDest()), this.options.getBoolean(this.noLogSetupArg.getDest()).booleanValue());
    }

    public String getDomain() {
        return this.options.getString(this.domainArg.getDest());
    }

    public String getServiceRegistryAddress() {
        return this.options.getString(this.serviceRegistryArg.getDest());
    }

    public Path getServiceRegistrarPlugin() {
        File plugin = (File)this.options.get(this.serviceRegistrarPluginArg.getDest());
        return plugin != null ? plugin.toPath() : null;
    }

    public String getZooKeeperConnectString() {
        return this.options.getString(this.zooKeeperConnectStringArg.getDest());
    }

    public String getSentryDsn() {
        return this.options.getString(this.sentryDsnArg.getDest());
    }

    public Boolean getInhibitMetrics() {
        return (Boolean)com.google.common.base.Optional.fromNullable((Object)this.options.getBoolean(this.noMetricsArg.getDest())).or((Object)false);
    }

    public String getName() {
        return this.options.getString(this.nameArg.getDest());
    }

    public String getRiemannHostPort() {
        return this.options.getString(this.riemannHostPortArg.getDest());
    }

    public String getStatsdHostPort() {
        return this.options.getString(this.statsdHostPortArg.getDest());
    }

    public int getZooKeeperConnectionTimeoutMillis() {
        return this.options.getInt(this.zooKeeperConnectiontimeoutArg.getDest());
    }

    public int getZooKeeperSessionTimeoutMillis() {
        return this.options.getInt(this.zooKeeperSessiontimeoutArg.getDest());
    }

    public String getZooKeeperClusterId() {
        return this.options.getString(this.zooKeeperClusterId.getDest());
    }

    public Boolean getNoZooKeeperRegistration() {
        return (Boolean)com.google.common.base.Optional.fromNullable((Object)this.options.getBoolean(this.noZooKeeperRegistrationArg.getDest())).or((Object)false);
    }

    public boolean getZooKeeperEnableAcls() {
        return this.options.getBoolean(this.zooKeeperEnableAcls.getDest());
    }

    public String getZooKeeperAclMasterUser() {
        return this.options.getString(this.zooKeeperAclMasterUser.getDest());
    }

    public String getZooKeeperAclAgentUser() {
        return this.options.getString(this.zooKeeperAclAgentUser.getDest());
    }

    public List<String> getKafkaBrokers() {
        List kafkaBrokers = this.options.getList(this.kafkaArg.getDest());
        return kafkaBrokers.isEmpty() ? null : kafkaBrokers;
    }

    public List<String> getPubsubPrefixes() {
        return this.options.getList(this.pubsubTopicPrefixArg.getDest());
    }

    public Path getStateDirectory() {
        return Paths.get(this.options.getString(this.stateDirArg.getDest()), new String[0]);
    }

    private static String getHostName() {
        return ServiceParser.exec("uname -n").trim();
    }

    private static String exec(String command) {
        try {
            Process process = Runtime.getRuntime().exec(command);
            return CharStreams.toString((Readable)new InputStreamReader(process.getInputStream(), Charsets.UTF_8));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected InetSocketAddress parseSocketAddress(String addressString) {
        InetSocketAddress address;
        try {
            URI u = new URI(addressString);
            address = new InetSocketAddress(u.getHost(), u.getPort());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Bad address: " + addressString, e);
        }
        return address;
    }

    protected FastForwardConfig ffwdConfig(Namespace options) {
        if (!options.getBoolean(this.ffwdEnabled.getDest()).booleanValue()) {
            return null;
        }
        return new FastForwardConfig(Optional.ofNullable(options.getString(this.ffwdAddress.getDest())), options.getInt(this.ffwdInterval.getDest()), options.getString(this.ffwdMetricKey.getDest()));
    }
}

