/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.google.common.base.Strings;
import com.spotify.helios.serviceregistration.NopServiceRegistrar;
import com.spotify.helios.serviceregistration.NopServiceRegistrarFactory;
import com.spotify.helios.serviceregistration.ServiceRegistrar;
import com.spotify.helios.serviceregistration.ServiceRegistrarFactory;
import com.spotify.helios.serviceregistration.ServiceRegistrarLoader;
import com.spotify.helios.serviceregistration.ServiceRegistrarLoadingException;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistrars {
    private static final Logger log = LoggerFactory.getLogger(ServiceRegistrars.class);

    public static ServiceRegistrar createServiceRegistrar(Path path, String address, String domain) {
        ServiceRegistrarFactory factory = path == null ? ServiceRegistrars.createFactory() : ServiceRegistrars.createFactory(path);
        if (address != null) {
            log.info("Creating service registrar with address: {}", (Object)address);
            return factory.create(address);
        }
        if (!Strings.isNullOrEmpty((String)domain)) {
            log.info("Creating service registrar for domain: {}", (Object)domain);
            return domain.equals("localhost") ? factory.create("tcp://localhost:4999") : factory.createForDomain(domain);
        }
        log.info("No address nor domain configured, not creating service registrar.");
        return new NopServiceRegistrar();
    }

    private static ServiceRegistrarFactory createFactory(Path path) {
        ServiceRegistrarFactory factory;
        Path absolutePath = path.toAbsolutePath();
        try {
            factory = ServiceRegistrarLoader.load((Path)absolutePath);
            String name = factory.getClass().getName();
            log.info("Loaded service registrar plugin: {} ({})", (Object)name, (Object)absolutePath);
        }
        catch (ServiceRegistrarLoadingException e) {
            throw new RuntimeException("Unable to load service registrar plugin: " + absolutePath, e);
        }
        return factory;
    }

    private static ServiceRegistrarFactory createFactory() {
        ServiceRegistrarFactory factory;
        ServiceRegistrarFactory installed;
        try {
            installed = ServiceRegistrarLoader.load();
        }
        catch (ServiceRegistrarLoadingException e) {
            throw new RuntimeException("Unable to load service registrar", e);
        }
        if (installed == null) {
            log.debug("No service registrar plugin configured");
            factory = new NopServiceRegistrarFactory();
        } else {
            factory = installed;
            String name = factory.getClass().getName();
            log.info("Loaded installed service registrar: {}", (Object)name);
        }
        return factory;
    }
}

