/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.google.common.collect.ImmutableList;
import io.dropwizard.jetty.HttpConnectorFactory;
import io.dropwizard.server.DefaultServerFactory;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;

public class ServiceUtil {
    public static DefaultServerFactory createServerFactory(InetSocketAddress httpEndpoint, InetSocketAddress adminEndpoint, boolean noHttp) {
        DefaultServerFactory serverFactory = new DefaultServerFactory();
        if (noHttp) {
            serverFactory.setApplicationConnectors(Collections.emptyList());
            serverFactory.setAdminConnectors(Collections.emptyList());
        } else {
            HttpConnectorFactory serviceConnector = new HttpConnectorFactory();
            serviceConnector.setPort(httpEndpoint.getPort());
            serviceConnector.setBindHost(httpEndpoint.getHostString());
            serverFactory.setApplicationConnectors((List)ImmutableList.of((Object)serviceConnector));
            HttpConnectorFactory adminConnector = new HttpConnectorFactory();
            adminConnector.setPort(adminEndpoint.getPort());
            adminConnector.setBindHost(adminEndpoint.getHostString());
            serverFactory.setAdminConnectors((List)ImmutableList.of((Object)adminConnector));
        }
        return serverFactory;
    }
}

