/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.spotify.helios.servicescommon.ZooKeeperAclProviders;
import com.spotify.helios.servicescommon.coordination.CuratorClientFactoryImpl;
import com.spotify.helios.servicescommon.coordination.DefaultZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.AuthInfo;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;

public class ZooKeeperAclInitializer {
    public static void main(String[] args) throws Exception {
        if (args.length == 6) {
            ZooKeeperAclInitializer.initializeAcl(args[0], args[1], args[2], args[3], args[4], args[5]);
        } else {
            System.out.println("usage: <ZK connect string> <ZK cluster ID> <master user> <master password> <agent user> <agent password>");
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initializeAcl(String zooKeeperConnectionString, String zooKeeperClusterId, String masterUser, String masterPassword, String agentUser, String agentPassword) throws KeeperException {
        ACLProvider aclProvider = ZooKeeperAclProviders.heliosAclProvider(masterUser, ZooKeeperAclProviders.digest(masterUser, masterPassword), agentUser, ZooKeeperAclProviders.digest(agentUser, agentPassword));
        ArrayList authorization = Lists.newArrayList((Object[])new AuthInfo[]{new AuthInfo("digest", String.format("%s:%s", masterUser, masterPassword).getBytes())});
        ExponentialBackoffRetry zooKeeperRetryPolicy = new ExponentialBackoffRetry(1000, 3);
        CuratorFramework curator = new CuratorClientFactoryImpl().newClient(zooKeeperConnectionString, (int)TimeUnit.SECONDS.toMillis(60L), (int)TimeUnit.SECONDS.toMillis(15L), (RetryPolicy)zooKeeperRetryPolicy, aclProvider, authorization);
        try (DefaultZooKeeperClient client = new DefaultZooKeeperClient(curator, zooKeeperClusterId);){
            client.start();
            ZooKeeperAclInitializer.initializeAclRecursive(client, "/", aclProvider);
        }
    }

    static void initializeAclRecursive(ZooKeeperClient client, String path, ACLProvider aclProvider) throws KeeperException {
        try {
            List expected = aclProvider.getAclForPath(path);
            List<ACL> actual = client.getAcl(path);
            if (!Sets.newHashSet((Iterable)expected).equals(Sets.newHashSet(actual))) {
                client.setAcl(path, expected);
            }
            for (String child : client.getChildren(path)) {
                ZooKeeperAclInitializer.initializeAclRecursive(client, path.replaceAll("/$", "") + "/" + child, aclProvider);
            }
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }
}

