/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.spotify.helios.common.Hash;
import com.spotify.helios.servicescommon.RuleBasedZooKeeperAclProvider;
import com.spotify.helios.servicescommon.coordination.Paths;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.bouncycastle.util.encoders.Base64;

public class ZooKeeperAclProviders {
    private static final String PATH_COMPONENT_WILDCARD = "[^/]+";
    private static final String DIGEST_SCHEME = "digest";

    public static String digest(String user, String password) {
        return Base64.toBase64String((byte[])Hash.sha1digest((byte[])String.format("%s:%s", user, password).getBytes()));
    }

    public static ACLProvider heliosAclProvider(String masterUser, String masterDigest, String agentUser, String agentDigest) {
        Id masterId = new Id(DIGEST_SCHEME, String.format("%s:%s", masterUser, masterDigest));
        Id agentId = new Id(DIGEST_SCHEME, String.format("%s:%s", agentUser, agentDigest));
        return RuleBasedZooKeeperAclProvider.builder().defaultAcl(new ACL(15, masterId), new ACL(1, agentId)).rule(".*", 15, masterId).rule(".*", 1, agentId).rule(Paths.configHosts(), 12, agentId).rule(Paths.configHost(PATH_COMPONENT_WILDCARD), 12, agentId).rule(Paths.configHostId(PATH_COMPONENT_WILDCARD), 12, agentId).rule(Paths.configHostPorts(PATH_COMPONENT_WILDCARD), 12, agentId).rule(Paths.statusHosts(), 12, agentId).rule(Paths.statusHost(PATH_COMPONENT_WILDCARD), 12, agentId).rule(Paths.statusHostJobs(PATH_COMPONENT_WILDCARD), 12, agentId).rule(Paths.statusHostJob(PATH_COMPONENT_WILDCARD, PATH_COMPONENT_WILDCARD), 2, agentId).rule(Paths.statusHostAgentInfo(PATH_COMPONENT_WILDCARD), 2, agentId).rule(Paths.statusHostInfo(PATH_COMPONENT_WILDCARD), 2, agentId).rule(Paths.statusHostLabels(PATH_COMPONENT_WILDCARD), 2, agentId).rule(Paths.statusHostEnvVars(PATH_COMPONENT_WILDCARD), 2, agentId).rule(Paths.statusHostUp(PATH_COMPONENT_WILDCARD), 2, agentId).rule(Paths.historyJobs() + "(/.+)?", 4, agentId).rule(Paths.historyJobHostEvents(PATH_COMPONENT_WILDCARD, PATH_COMPONENT_WILDCARD), 8, agentId).build();
    }
}

