/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import com.spotify.helios.agent.BoundedRandomExponentialBackoff;
import com.spotify.helios.agent.RetryIntervalPolicy;
import com.spotify.helios.agent.RetryScheduler;
import com.spotify.helios.agent.Sleeper;
import com.spotify.helios.agent.ThreadSleeper;
import com.spotify.helios.master.HostNotFoundException;
import com.spotify.helios.servicescommon.DefaultReactor;
import com.spotify.helios.servicescommon.Reactor;
import com.spotify.helios.servicescommon.ZooKeeperRegistrar;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperRegistrarService
extends AbstractIdleService {
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperRegistrarService.class);
    private final ZooKeeperClient client;
    private final ZooKeeperRegistrar zooKeeperRegistrar;
    private final Optional<CountDownLatch> zkRegistrationSignal;
    private final RetryIntervalPolicy retryIntervalPolicy;
    private final Sleeper sleeper;
    private final Reactor reactor;
    private ConnectionStateListener listener = new ConnectionStateListener(){

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            if (newState == ConnectionState.RECONNECTED) {
                ZooKeeperRegistrarService.this.reactor.signal();
            }
        }
    };

    private ZooKeeperRegistrarService(Builder builder) {
        this.client = (ZooKeeperClient)Preconditions.checkNotNull((Object)builder.zooKeeperClient);
        this.zooKeeperRegistrar = (ZooKeeperRegistrar)Preconditions.checkNotNull((Object)builder.zooKeeperRegistrar);
        this.zkRegistrationSignal = Optional.ofNullable(builder.zkRegistrationSignal);
        this.retryIntervalPolicy = (RetryIntervalPolicy)Preconditions.checkNotNull((Object)builder.retryIntervalPolicy);
        this.sleeper = (Sleeper)Preconditions.checkNotNull((Object)builder.sleeper);
        this.reactor = new DefaultReactor("zk-client-async-init", new Update());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    protected void startUp() throws Exception {
        this.zooKeeperRegistrar.startUp();
        this.client.getConnectionStateListenable().addListener((Object)this.listener);
        this.reactor.startAsync().awaitRunning();
        this.reactor.signal();
    }

    protected void shutDown() throws Exception {
        this.reactor.stopAsync().awaitTerminated();
        this.zooKeeperRegistrar.shutDown();
    }

    private boolean isAlive() {
        return this.state().ordinal() < Service.State.STOPPING.ordinal();
    }

    private class Update
    implements Reactor.Callback {
        private Update() {
        }

        @Override
        public void run(boolean timeout) throws InterruptedException {
            RetryScheduler retryScheduler = ZooKeeperRegistrarService.this.retryIntervalPolicy.newScheduler();
            while (ZooKeeperRegistrarService.this.isAlive()) {
                long sleep = retryScheduler.nextMillis();
                boolean successfullyRegistered = false;
                try {
                    successfullyRegistered = ZooKeeperRegistrarService.this.zooKeeperRegistrar.tryToRegister(ZooKeeperRegistrarService.this.client);
                }
                catch (Exception e) {
                    if (e instanceof KeeperException.ConnectionLossException) {
                        log.warn("ZooKeeper connection lost, retrying registration in {} ms", (Object)sleep);
                    }
                    if (e instanceof HostNotFoundException) {
                        log.error("ZooKeeper deregistration of old hostname failed, retrying in {} ms: {}", (Object)sleep, (Object)e);
                    }
                    log.error("ZooKeeper registration failed, retrying in {} ms", (Object)sleep, (Object)e);
                }
                if (successfullyRegistered) {
                    log.info("Successfully registered host in zookeeper");
                    ZooKeeperRegistrarService.this.zkRegistrationSignal.ifPresent(CountDownLatch::countDown);
                    return;
                }
                log.warn("registration not successful, sleeping for {} seconds", (Object)TimeUnit.MILLISECONDS.toSeconds(sleep));
                ZooKeeperRegistrarService.this.sleeper.sleep(sleep);
            }
        }
    }

    public static class Builder {
        private ZooKeeperClient zooKeeperClient;
        private ZooKeeperRegistrar zooKeeperRegistrar;
        private CountDownLatch zkRegistrationSignal;
        private RetryIntervalPolicy retryIntervalPolicy;
        private Sleeper sleeper;

        private Builder() {
        }

        public Builder setZooKeeperClient(ZooKeeperClient zooKeeperClient) {
            this.zooKeeperClient = zooKeeperClient;
            return this;
        }

        public Builder setZooKeeperRegistrar(ZooKeeperRegistrar zooKeeperRegistrar) {
            this.zooKeeperRegistrar = zooKeeperRegistrar;
            return this;
        }

        public Builder setZKRegistrationSignal(CountDownLatch zkRegistrationSignal) {
            this.zkRegistrationSignal = zkRegistrationSignal;
            return this;
        }

        public Builder setRetryIntervalPolicy(RetryIntervalPolicy retryIntervalPolicy) {
            this.retryIntervalPolicy = retryIntervalPolicy;
            return this;
        }

        public Builder setSleeper(Sleeper sleeper) {
            this.sleeper = sleeper;
            return this;
        }

        public ZooKeeperRegistrarService build() {
            if (this.retryIntervalPolicy == null) {
                this.retryIntervalPolicy = BoundedRandomExponentialBackoff.newBuilder().setMinInterval(1L, TimeUnit.SECONDS).setMaxInterval(30L, TimeUnit.SECONDS).build();
            }
            if (this.sleeper == null) {
                this.sleeper = new ThreadSleeper();
            }
            return new ZooKeeperRegistrarService(this);
        }
    }
}

