/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.spotify.helios.common.HeliosRuntimeException;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.AgentInfo;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Descriptor;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.HostInfo;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.Task;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.master.HostNotFoundException;
import com.spotify.helios.master.HostStillInUseException;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.ZooKeeperOperations;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperRegistrarUtil {
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperRegistrarUtil.class);
    private static final Map<JobId, TaskStatus> EMPTY_STATUSES = Collections.emptyMap();
    private static final TypeReference<HostInfo> HOST_INFO_TYPE = new TypeReference<HostInfo>(){};
    private static final TypeReference<AgentInfo> AGENT_INFO_TYPE = new TypeReference<AgentInfo>(){};
    private static final TypeReference<Map<String, String>> STRING_MAP_TYPE = new TypeReference<Map<String, String>>(){};

    public static void registerHost(ZooKeeperClient client, String idPath, String hostname, String hostId) throws KeeperException {
        log.info("registering host: {}", (Object)hostname);
        client.ensurePath(Paths.configHost(hostname));
        client.ensurePath(Paths.configHostJobs(hostname));
        client.ensurePath(Paths.configHostPorts(hostname));
        client.ensurePath(Paths.statusHost(hostname));
        client.ensurePath(Paths.statusHostJobs(hostname));
        client.createAndSetData(idPath, hostId.getBytes(Charsets.UTF_8));
    }

    public static void reRegisterHost(ZooKeeperClient client, String host, String hostId) throws HostNotFoundException, KeeperException {
        log.info("re-registering host: {}, new host id: {}", (Object)host, (Object)hostId);
        try {
            ArrayList operations = Lists.newArrayList();
            operations.add(ZooKeeperOperations.check(Paths.configHost(host)));
            List<String> nodes = ZooKeeperRegistrarUtil.safeListRecursive(client, Paths.statusHost(host));
            for (String node : Lists.reverse(nodes)) {
                operations.add(ZooKeeperOperations.delete(node));
            }
            operations.add(ZooKeeperOperations.create(Paths.statusHost(host)));
            operations.add(ZooKeeperOperations.create(Paths.statusHostJobs(host)));
            operations.add(ZooKeeperOperations.delete(Paths.configHostId(host)));
            operations.add(ZooKeeperOperations.create(Paths.configHostId(host), hostId.getBytes(Charsets.UTF_8)));
            client.transaction(operations);
        }
        catch (KeeperException.NoNodeException e) {
            throw new HostNotFoundException(host);
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException((Throwable)e);
        }
    }

    public static void deregisterHost(ZooKeeperClient client, String host) throws HostNotFoundException, HostStillInUseException {
        log.info("deregistering host: {}", (Object)host);
        try {
            ArrayList operations = Lists.newArrayList();
            if (client.exists(Paths.configHost(host)) == null) {
                throw new HostNotFoundException("host [" + host + "] does not exist");
            }
            List<String> jobs = ZooKeeperRegistrarUtil.safeGetChildren(client, Paths.configHostJobs(host));
            for (String string : jobs) {
                JobId job = JobId.fromString((String)string);
                String hostJobPath = Paths.configHostJob(host, job);
                List<String> nodes = ZooKeeperRegistrarUtil.safeListRecursive(client, hostJobPath);
                for (String node : Lists.reverse(nodes)) {
                    operations.add(ZooKeeperOperations.delete(node));
                }
                if (client.exists(Paths.configJobHost(job, host)) != null) {
                    operations.add(ZooKeeperOperations.delete(Paths.configJobHost(job, host)));
                }
                List<String> history = ZooKeeperRegistrarUtil.safeListRecursive(client, Paths.historyJobHost(job, host));
                for (String s : Lists.reverse(history)) {
                    operations.add(ZooKeeperOperations.delete(s));
                }
            }
            operations.add(ZooKeeperOperations.delete(Paths.configHostJobs(host)));
            List<String> nodes = ZooKeeperRegistrarUtil.safeListRecursive(client, Paths.statusHost(host));
            for (Object node : Lists.reverse(nodes)) {
                operations.add(ZooKeeperOperations.delete((String)node));
            }
            List<String> list = ZooKeeperRegistrarUtil.safeGetChildren(client, Paths.configHostPorts(host));
            for (String port : list) {
                operations.add(ZooKeeperOperations.delete(Paths.configHostPort(host, Integer.valueOf(port))));
            }
            operations.add(ZooKeeperOperations.delete(Paths.configHostPorts(host)));
            String idPath = Paths.configHostId(host);
            if (client.exists(idPath) != null) {
                operations.add(ZooKeeperOperations.delete(idPath));
            }
            operations.add(ZooKeeperOperations.delete(Paths.configHost(host)));
            client.transaction(operations);
        }
        catch (KeeperException.NoNodeException e) {
            throw new HostNotFoundException(host);
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException((Throwable)e);
        }
    }

    private static List<JobId> listHostJobs(ZooKeeperClient client, String host) {
        List<String> jobIdStrings;
        String folder = Paths.statusHostJobs(host);
        try {
            jobIdStrings = client.getChildren(folder);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("List tasks for host failed: " + host, (Throwable)e);
        }
        ImmutableList.Builder jobIds = ImmutableList.builder();
        for (String jobIdString : jobIdStrings) {
            jobIds.add((Object)JobId.fromString((String)jobIdString));
        }
        return jobIds.build();
    }

    private static List<String> safeGetChildren(ZooKeeperClient client, String path) {
        try {
            return client.getChildren(path);
        }
        catch (KeeperException ignore) {
            return ImmutableList.of();
        }
    }

    private static List<String> safeListRecursive(ZooKeeperClient client, String path) throws KeeperException {
        try {
            return client.listRecursive(path);
        }
        catch (KeeperException.NoNodeException e) {
            return ImmutableList.of();
        }
    }

    private static HostStatus getHostStatus(ZooKeeperClient client, String host) {
        Stat stat;
        try {
            stat = client.exists(Paths.configHostId(host));
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("Failed to check host status", (Throwable)e);
        }
        if (stat == null) {
            return null;
        }
        boolean up = ZooKeeperRegistrarUtil.checkHostUp(client, host);
        HostInfo hostInfo = ZooKeeperRegistrarUtil.getHostInfo(client, host);
        AgentInfo agentInfo = ZooKeeperRegistrarUtil.getAgentInfo(client, host);
        Map<JobId, Deployment> tasks = ZooKeeperRegistrarUtil.getTasks(client, host);
        Map<JobId, TaskStatus> statuses = ZooKeeperRegistrarUtil.getTaskStatuses(client, host);
        Map<String, String> environment = ZooKeeperRegistrarUtil.getEnvironment(client, host);
        return HostStatus.newBuilder().setJobs(tasks).setStatuses((Map)Optional.fromNullable(statuses).or(EMPTY_STATUSES)).setHostInfo(hostInfo).setAgentInfo(agentInfo).setStatus(up ? HostStatus.Status.UP : HostStatus.Status.DOWN).setEnvironment(environment).build();
    }

    private static Map<String, String> getEnvironment(ZooKeeperClient client, String host) {
        return ZooKeeperRegistrarUtil.tryGetEntity(client, Paths.statusHostEnvVars(host), STRING_MAP_TYPE, "environment");
    }

    private static AgentInfo getAgentInfo(ZooKeeperClient client, String host) {
        return ZooKeeperRegistrarUtil.tryGetEntity(client, Paths.statusHostAgentInfo(host), AGENT_INFO_TYPE, "agent info");
    }

    private static HostInfo getHostInfo(ZooKeeperClient client, String host) {
        return ZooKeeperRegistrarUtil.tryGetEntity(client, Paths.statusHostInfo(host), HOST_INFO_TYPE, "host info");
    }

    private static boolean checkHostUp(ZooKeeperClient client, String host) {
        try {
            Stat stat = client.exists(Paths.statusHostUp(host));
            return stat != null;
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("getting host " + host + " up status failed", (Throwable)e);
        }
    }

    private static Map<JobId, TaskStatus> getTaskStatuses(ZooKeeperClient client, String host) {
        HashMap statuses = Maps.newHashMap();
        List<JobId> jobIds = ZooKeeperRegistrarUtil.listHostJobs(client, host);
        if (jobIds == null) {
            return statuses;
        }
        for (JobId jobId : jobIds) {
            TaskStatus status = ZooKeeperRegistrarUtil.getTaskStatus(client, host, jobId);
            if (status != null) {
                statuses.put(jobId, status);
                continue;
            }
            log.debug("Task {} status missing for host {}", (Object)jobId, (Object)host);
        }
        return statuses;
    }

    @Nullable
    private static TaskStatus getTaskStatus(ZooKeeperClient client, String host, JobId jobId) {
        String containerPath = Paths.statusHostJob(host, jobId);
        try {
            byte[] data = client.getData(containerPath);
            return (TaskStatus)Descriptor.parse((byte[])data, TaskStatus.class);
        }
        catch (KeeperException.NoNodeException ignored) {
            return null;
        }
        catch (IOException | KeeperException e) {
            throw new HeliosRuntimeException("Getting task " + jobId + " status for host " + host + " failed", e);
        }
    }

    private static <T> T tryGetEntity(ZooKeeperClient client, String path, TypeReference<T> type, String name) {
        try {
            byte[] data = client.getData(path);
            return (T)Json.read((byte[])data, type);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (IOException | KeeperException e) {
            throw new HeliosRuntimeException("reading " + name + " info failed", e);
        }
    }

    private static Map<JobId, Deployment> getTasks(ZooKeeperClient client, String host) {
        HashMap jobs = Maps.newHashMap();
        try {
            List<String> jobIds;
            String folder = Paths.configHostJobs(host);
            try {
                jobIds = client.getChildren(folder);
            }
            catch (KeeperException.NoNodeException e) {
                return null;
            }
            for (String jobIdString : jobIds) {
                JobId jobId = JobId.fromString((String)jobIdString);
                String containerPath = Paths.configHostJob(host, jobId);
                try {
                    byte[] data = client.getData(containerPath);
                    Task task = (Task)Descriptor.parse((byte[])data, Task.class);
                    jobs.put(jobId, Deployment.of((JobId)jobId, (Goal)task.getGoal()));
                }
                catch (KeeperException.NoNodeException ignored) {
                    log.debug("deployment config node disappeared: {}", (Object)jobIdString);
                }
            }
        }
        catch (IOException | KeeperException e) {
            throw new HeliosRuntimeException("getting deployment config failed", e);
        }
        return jobs;
    }
}

