/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon.coordination;

import com.spotify.helios.servicescommon.coordination.ZooKeeperOperation;
import java.util.Arrays;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.framework.api.transaction.CuratorTransaction;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;

class CreateWithDataAndVersion
implements ZooKeeperOperation {
    private final String path;
    private final byte[] data;
    private final int version;

    CreateWithDataAndVersion(String path, byte[] data, int version) {
        this.path = path;
        this.data = data;
        this.version = version;
    }

    @Override
    public void register(CuratorTransaction transaction) throws Exception {
        ((PathAndBytesable)((CuratorTransactionBridge)transaction.create().forPath(this.path)).and().setData().withVersion(this.version)).forPath(this.path, this.data);
    }

    public String toString() {
        return "CreateWithDataAndVersion{path='" + this.path + '\'' + ", version=" + this.version + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateWithDataAndVersion that = (CreateWithDataAndVersion)o;
        if (this.version != that.version) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        int result = this.path != null ? this.path.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.data);
        result = 31 * result + this.version;
        return result;
    }
}

