/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon.coordination;

import com.spotify.helios.servicescommon.coordination.CuratorClientFactory;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.AuthInfo;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorClientFactoryImpl
implements CuratorClientFactory {
    private static final Logger log = LoggerFactory.getLogger(CuratorClientFactoryImpl.class);

    @Override
    public CuratorFramework newClient(String connectString, int sessionTimeoutMs, int connectionTimeoutMs, RetryPolicy retryPolicy, ACLProvider aclProvider, List<AuthInfo> authorization) {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(connectString).sessionTimeoutMs(sessionTimeoutMs).connectionTimeoutMs(connectionTimeoutMs).retryPolicy(retryPolicy);
        if (aclProvider != null) {
            builder.aclProvider(aclProvider);
        }
        if (authorization != null && !authorization.isEmpty()) {
            builder.authorization(authorization);
        }
        return builder.build();
    }
}

