/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon.coordination;

import com.fasterxml.jackson.databind.JavaType;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.spotify.helios.servicescommon.coordination.Node;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.servicescommon.coordination.PersistentPathChildrenCache;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.ZooKeeperOperation;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.framework.api.transaction.CuratorTransaction;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.curator.framework.api.transaction.CuratorTransactionFinal;
import org.apache.curator.framework.api.transaction.CuratorTransactionResult;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.listen.Listenable;
import org.apache.curator.framework.recipes.nodes.PersistentEphemeralNode;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.utils.PathUtils;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultZooKeeperClient
implements ZooKeeperClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultZooKeeperClient.class);
    private final CuratorFramework client;
    private final String clusterId;
    private final AtomicBoolean clusterIdExists;
    private final Watcher watcher;
    private final ConnectionStateListener connectionStateListener;

    public DefaultZooKeeperClient(CuratorFramework client) {
        this(client, null);
    }

    public DefaultZooKeeperClient(CuratorFramework client, final String clusterId) {
        this.client = client;
        this.clusterId = clusterId;
        if (clusterId == null) {
            this.clusterIdExists = null;
            this.watcher = null;
            this.connectionStateListener = null;
            return;
        }
        this.clusterIdExists = new AtomicBoolean(false);
        this.watcher = new Watcher(){

            public void process(WatchedEvent event) {
                log.info("DefaultZooKeeperClient processing WatchedEvent - {}", (Object)event);
                DefaultZooKeeperClient.this.checkClusterIdExists(clusterId, "watcher");
            }
        };
        this.connectionStateListener = new ConnectionStateListener(){

            public void stateChanged(CuratorFramework client, ConnectionState newState) {
                log.info("DefaultZooKeeperClient connection state change - {}", (Object)newState);
                if (newState == ConnectionState.RECONNECTED) {
                    DefaultZooKeeperClient.this.checkClusterIdExists(clusterId, "connectionStateListener");
                }
            }
        };
    }

    @Override
    public CuratorFramework getCuratorFramework() {
        return this.client;
    }

    @Override
    public void ensurePath(String path) throws KeeperException {
        this.ensurePath(path, false);
    }

    @Override
    public void ensurePath(String path, boolean excludingLast) throws KeeperException {
        PathUtils.validatePath((String)path);
        this.assertClusterIdFlagTrue();
        String[] parts = path.substring(1).split(Pattern.quote("/"));
        int end = excludingLast ? parts.length - 1 : parts.length;
        String current = "";
        for (int i = 0; i < end; ++i) {
            if (this.exists(current = current + "/" + parts[i]) != null) continue;
            this.create(current);
        }
    }

    @Override
    public void ensurePathAndSetData(String path, byte[] data) throws KeeperException {
        this.ensurePath(path, true);
        if (this.exists(path) == null) {
            this.createAndSetData(path, data);
        }
    }

    @Override
    public byte[] getData(String path) throws KeeperException {
        this.assertClusterIdFlagTrue();
        try {
            return (byte[])this.client.getData().forPath(path);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Node getNode(String path) throws KeeperException {
        this.assertClusterIdFlagTrue();
        Stat stat = new Stat();
        try {
            byte[] bytes = (byte[])((WatchPathable)this.client.getData().storingStatIn(stat)).forPath(path);
            return new Node(path, bytes, stat);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Stat exists(String path) throws KeeperException {
        return this.stat(path);
    }

    @Override
    public void start() {
        if (this.client.getState() != CuratorFrameworkState.STARTED) {
            this.client.start();
            if (this.clusterId != null) {
                this.client.getConnectionStateListenable().addListener((Object)this.connectionStateListener);
                this.checkClusterIdExists(this.clusterId, "start");
            }
        }
    }

    @Override
    public void close() {
        if (this.clusterId != null) {
            this.client.getConnectionStateListenable().removeListener((Object)this.connectionStateListener);
        }
        this.client.close();
    }

    @Override
    public PersistentEphemeralNode persistentEphemeralNode(String path, PersistentEphemeralNode.Mode mode, byte[] data) {
        this.assertClusterIdFlagTrue();
        PersistentEphemeralNode node = new PersistentEphemeralNode(this.client, mode, path, data);
        try {
            Field field = node.getClass().getDeclaredField("createMethod");
            field.setAccessible(true);
            field.set(node, this.client.create());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return node;
    }

    @Override
    public Listenable<ConnectionStateListener> getConnectionStateListenable() {
        return this.client.getConnectionStateListenable();
    }

    @Override
    public ZooKeeper.States getState() throws KeeperException {
        this.assertClusterIdFlagTrue();
        try {
            return this.client.getZookeeperClient().getZooKeeper().getState();
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public List<String> getChildren(String path) throws KeeperException {
        this.assertClusterIdFlagTrue();
        try {
            return (List)this.client.getChildren().forPath(path);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void deleteRecursive(String path) throws KeeperException {
        this.assertClusterIdFlagTrue();
        try {
            List<String> nodes = this.listRecursive(path);
            if (nodes.isEmpty()) {
                return;
            }
            CuratorTransactionFinal t = ((CuratorTransactionBridge)this.client.inTransaction().check().forPath(path)).and();
            for (String node : Lists.reverse(nodes)) {
                ((CuratorTransactionBridge)t.delete().forPath(node)).and();
            }
            t.commit();
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public List<String> listRecursive(String path) throws KeeperException {
        this.assertClusterIdFlagTrue();
        LinkedList queue = Lists.newLinkedList();
        ArrayList tree = Lists.newArrayList();
        queue.add(path);
        tree.add(path);
        while (!queue.isEmpty()) {
            String node = (String)queue.pollFirst();
            List<String> children = this.getChildren(node);
            for (String child : children) {
                String childPath = node.replaceAll("/$", "") + "/" + child;
                queue.add(childPath);
                tree.add(childPath);
            }
        }
        return tree;
    }

    @Override
    public void delete(String path) throws KeeperException {
        this.assertClusterIdFlagTrue();
        try {
            this.client.delete().forPath(path);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void delete(String path, int version) throws KeeperException {
        this.assertClusterIdFlagTrue();
        String namespace = Strings.emptyToNull((String)this.client.getNamespace());
        String namespacedPath = ZKPaths.fixForNamespace((String)namespace, (String)path);
        try {
            this.client.getZookeeperClient().getZooKeeper().delete(namespacedPath, version);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void createAndSetData(String path, byte[] data) throws KeeperException {
        this.assertClusterIdFlagTrue();
        try {
            this.client.create().forPath(path, data);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void create(String path) throws KeeperException {
        this.assertClusterIdFlagTrue();
        try {
            this.client.create().forPath(path);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void createWithMode(String path, CreateMode mode) throws KeeperException {
        this.assertClusterIdFlagTrue();
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().withMode(mode)).forPath(path);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void setData(String path, byte[] data) throws KeeperException {
        this.assertClusterIdFlagTrue();
        try {
            this.client.setData().forPath(path, data);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Stat stat(String path) throws KeeperException {
        this.assertClusterIdFlagTrue();
        try {
            return (Stat)this.client.checkExists().forPath(path);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public <T> PersistentPathChildrenCache<T> pathChildrenCache(String path, Path snapshotFile, JavaType valueType) throws IOException, InterruptedException {
        return new PersistentPathChildrenCache(this.client, path, this.clusterId, snapshotFile, valueType);
    }

    @Override
    public Collection<CuratorTransactionResult> transaction(List<ZooKeeperOperation> operations) throws KeeperException {
        this.assertClusterIdFlagTrue();
        log.debug("transaction: {}", operations);
        if (operations.isEmpty()) {
            return Collections.emptyList();
        }
        CuratorTransactionFinal transaction = (CuratorTransactionFinal)this.client.inTransaction();
        for (ZooKeeperOperation operation : operations) {
            try {
                operation.register((CuratorTransaction)transaction);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        try {
            return transaction.commit();
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Collection<CuratorTransactionResult> transaction(ZooKeeperOperation ... operations) throws KeeperException {
        return this.transaction(Arrays.asList(operations));
    }

    @Override
    public void setAcl(String path, List<ACL> aclList) throws KeeperException {
        this.assertClusterIdFlagTrue();
        try {
            ((BackgroundPathable)this.client.setACL().withACL(aclList)).forPath(path);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public List<ACL> getAcl(String path) throws KeeperException {
        this.assertClusterIdFlagTrue();
        try {
            return (List)this.client.getACL().forPath(path);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void assertClusterIdFlagTrue() {
        if (this.clusterId != null && !this.clusterIdExists.get()) {
            throw new IllegalStateException("ZooKeeper cluster ID does not exist");
        }
    }

    private void checkClusterIdExists(String id, String checker) {
        try {
            Stat stat = (Stat)((BackgroundPathable)this.client.checkExists().usingWatcher(this.watcher)).forPath(Paths.configId(id));
            boolean exists = stat != null;
            this.clusterIdExists.set(exists);
            log.info("Cluster ID {} {} when checked by {}", new Object[]{id, exists ? "exists" : "does not exist", checker});
        }
        catch (Exception e) {
            this.clusterIdExists.set(false);
            log.error("Exception while checking ZooKeeper cluster ID {}", (Object)this.clusterId, (Object)e);
        }
    }
}

