/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon.coordination;

import org.apache.zookeeper.common.PathUtils;

public class PathFactory {
    private final String base;

    public PathFactory(String base, String ... parts) {
        String joined = this.join(base, parts);
        this.base = joined.startsWith("/") ? joined : "/" + joined;
        PathUtils.validatePath((String)base);
    }

    public String path(String ... parts) {
        String path = this.join(this.base, parts);
        PathUtils.validatePath((String)path);
        return path;
    }

    private String join(String base, String ... parts) {
        StringBuilder builder = new StringBuilder(base);
        for (String part : parts) {
            if (part.isEmpty()) continue;
            if (builder.charAt(builder.length() - 1) != '/' && part.charAt(0) != '/') {
                builder.append('/');
            }
            builder.append(part);
        }
        return builder.toString();
    }
}

